<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminMediaController extends LinevenRlpController
{

    /**
     * Index action.
     * @return void
     */
    public function indexAction()
    {
        $context = Context::getContext();
        if ($this->module_context->isModuleActive() &&
            $context->controller->controller_name == 'AdminProducts' &&
            Configuration::get('LINEVEN_RLP_ACTIVE_BO_ADM_PRD')) {
            $context->controller->addCSS(LinevenRlpTools::getBaseURI().'views/css/admin/rlp-module.css');
            $context->controller->addJS(LinevenRlpTools::getBaseURI().'views/js/admin/rlp-lineven.js');
            $context->controller->addJS(LinevenRlpTools::getBaseURI().'views/js/admin/rlp-module.js');
            $id_product = (int)Tools::getValue('id_product');
            if (!(int)$id_product && version_compare(_PS_VERSION_, '1.7.0.0', '>=')
                && version_compare(_PS_VERSION_, '1.7.4.0', '<')) {
                // Note for Prestashop - global is required to get the request object
                global $kernel;
                $request = $kernel->getContainer()->get('request');
                $id_product = (int)$request->get('id');
            } else {
                if (version_compare(_PS_VERSION_, '1.7.4.0', '>=')) {
                    // For Prestashop >=1.4
                    $sfContainer = PrestaShop\PrestaShop\Adapter\SymfonyContainer::getInstance();
                    if (!is_null($sfContainer) && !is_null($sfContainer->get('request_stack')->getCurrentRequest())) {
                        $request = $sfContainer->get('request_stack')->getCurrentRequest();
                        $id_product = (int)$request->get('id');
                    }
                }
            }
            if ((int)$id_product) {
                $product = new Product((int)$id_product, true, $context->language->id, $context->shop->id);
                if (Validate::isLoadedObject($product)) {
                    $context->controller->addJS(LinevenRlpTools::getBaseURI().'views/js/admin/rlp-module-catalog-product.js');
                }
            }
        }
        $this->presenter->noRender();
    }
}
