<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminAssociationsSettingsController extends LinevenRlpController
{
    /**
     * Rules settings action.
     * @return void
     */
    public function rulesAction()
    {
        $helper = new LinevenRlpHelperForm('AssociationsSettings', 'rules', 'associations:rules');
        $presenter = new LinevenRlpModuleAdminPresenter();
        $helper->form = new LinevenRlpFormAdminAssociationRules();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your rules settings have been updated.', 'AssociationsSettings')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $this->presenter->setDatas($presenter->present());
        $this->presenter->addOutput('content', $helper->generateForm());
    }

    /**
     * Availability settings action.
     * @return void
     */
    public function availabilityAction()
    {
        $helper = new LinevenRlpHelperForm('AssociationsSettings', 'availability', 'associations:availability');
        $presenter = new LinevenRlpModuleAdminPresenter();
        $helper->form = new LinevenRlpFormAdminAssociationsAvailability();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your availability settings have been updated.', 'AssociationsSettings')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $this->presenter->setDatas($presenter->present());
        $this->presenter->addOutput('content', $helper->generateForm());
    }

    /**
     * Display settings action.
     * @return void
     */
    public function displayAction()
    {
        $helper = new LinevenRlpHelperForm('AssociationsSettings', 'display', 'associations:display_settings');
        $presenter = new LinevenRlpModuleAdminPresenter();
        $helper->form = new LinevenRlpFormAdminAssociationsDisplay();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your display settings have been updated.', 'AssociationsSettings')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $this->presenter->setDatas($presenter->present());
        $this->presenter->addOutput('content', $helper->generateForm());
    }
}
