<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminCatalogController extends LinevenRlpController
{
    
    /**
     * Quickly add product.
     * @return void
     */
    public function quicklyAddProductAction()
    {
        $return = array('result' => false, 'html' => '');
        $this->presenter->noRender();
        if (Tools::isSubmit('id_related_product') && Tools::isSubmit('id_displayed_product') &&
            Tools::getValue('id_related_product') != 0 && Tools::getValue('id_related_product') != '' &&
            Tools::getValue('id_displayed_product') != 0 && Tools::getValue('id_displayed_product') != '') {
            $configuration = LinevenRlpConfiguration::getConfiguration();
            $return['result'] = LinevenRlpAssociation::addQuicklyAssociation((int)Tools::getValue('id_related_product'), (int)Tools::getValue('id_displayed_product'));
            if ($return['result']) {
                $associations_presenter = new LinevenRlpAssociationAdminListingPresenter();
                $products = $associations_presenter->presentListForProduct(
                    LinevenRlpAssociation::getByRelatedProduct((int)Tools::getValue('id_related_product'))
                );
                Context::getContext()->smarty->assign(array(
                    'link' => Context::getContext()->link,
                    'displayed_products' => $products
                ));
                $return['html'] =  $configuration->getModule()->display(
                    _PS_MODULE_DIR_.$configuration->getModule()->name,
                    'views/templates/hook/admin/catalog/list_products_displayed.tpl'
                );
            }
        }
        die(
            Tools::jsonEncode($return)
        );
    }
    
    /**
     * Delete association action.
     * @return void
     */
    public function deleteAssociationAction()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $return = array('result' => false, 'html' => '');
        $this->presenter->noRender();
        if (Tools::isSubmit('id_association') && Tools::getValue('id_association') != '') {
            $return['result'] = LinevenRlpAssociation::staticDelete((int)Tools::getValue('id_association'));
            if ($return['result']) {
                $associations_presenter = new LinevenRlpAssociationAdminListingPresenter();
                $products = $associations_presenter->presentListForProduct(
                    LinevenRlpAssociation::getByRelatedProduct((int)Tools::getValue('id_related_product'))
                );
                Context::getContext()->smarty->assign(array(
                    'link' => Context::getContext()->link,
                    'displayed_products' => $products
                ));
                $return['html'] =  $configuration->getModule()->display(
                    _PS_MODULE_DIR_.$configuration->getModule()->name,
                    'views/templates/hook/admin/catalog/list_products_displayed.tpl'
                );
            }
        }
        die(
            Tools::jsonEncode($return)
        );
    }

    /**
     * Get products action.
     * @return void
     */
    public function getProductsAction()
    {
        $this->presenter->noRender();
        $products_search = new LinevenRlpAssociationAdminProductsSearch();
        $items = $products_search->runQuery(Tools::getValue('q', false), 'query');
        $products = array();
        if ($items) {
            foreach ($items as $item) {
                $products[] = array(
                    'id' => (int)$item['id_product'],
                    'name' => trim($item['name']),
                    'ref' => trim($item['reference']),
                    'image' => LinevenRlpProductPresenter::getThumbnailImage((int)$item['id_product']),
                );
            }
        }
        die(Tools::jsonEncode($products));
    }
}
