<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminDashboardController extends LinevenRlpModuleDashboardController
{
    /**
     * Dashboard.
     * @return void
     */
    public function indexAction()
    {
        parent::indexAction();

        // Report
        $associations = LinevenRlpAssociation::getAssociations();
        $this->presenter->addData('associations_report', array(
            'rules_cart' => Configuration::get('LINEVEN_RLP_INCLUDE_CART'),
            'rules_order' => Configuration::get('LINEVEN_RLP_INCLUDE_ORDERS'),
            'rules_viewed' => Configuration::get('LINEVEN_RLP_INCLUDE_VIEWED'),
            'plugins' => RelatedProducts::getPlugins(),
            'associations_count' => count($associations)
        ));
        $report_addons_reviews_associated = false;
        if (LinevenRlpPartners::verifyModule(RelatedProducts::$partner_reviews_module_lineven)
            && Configuration::get('LINEVEN_RLP_PARTNER_RVW_RATE')) {
            $report_addons_reviews_associated = true;
        }
        $this->presenter->addData('report_addons_reviews_associated', $report_addons_reviews_associated);
    }
}
