<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminDiagnosticController extends LinevenRlpModuleDiagnosticController
{
    protected $is_functional_diagnostic = true;

    /*
     * Check product image used in popup.
     *
     * @return array
     */
    protected function checkProductImageUsedInColumn()
    {
        $product_image_found = LinevenRlpAdminDiagnostic::checkProductImageUsed('OCL');
        $this->has_output = !$product_image_found;
    }

    /*
     * Check product image used in product  page.
     *
     * @return array
     */
    protected function checkProductImageUsedInProductPage()
    {
        $product_image_found = LinevenRlpAdminDiagnostic::checkProductImageUsed('OPP');
        $this->has_output = !$product_image_found;
    }

    /*
     * Check product image used in quick view.
     *
     * @return array
     */
    protected function checkProductImageUsedInQuickView()
    {
        $product_image_found = LinevenRlpAdminDiagnostic::checkProductImageUsed('OQV');
        $this->has_output = !$product_image_found;
    }

    /*
     * Check product image used in order page.
     *
     * @return array
     */
    protected function checkProductImageUsedInOrderPage()
    {
        $product_image_found = LinevenRlpAdminDiagnostic::checkProductImageUsed('OOP');
        $this->has_output = !$product_image_found;
    }

    /*
     * Check product image used in ajax cart.
     *
     * @return array
     */
    protected function checkProductImageUsedInAjaxCart()
    {
        $product_image_found = LinevenRlpAdminDiagnostic::checkProductImageUsed('OAC');
        $this->has_output = !$product_image_found;
    }

    /*
     * Check smarty template used in home page.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInHomePage()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OHP', 'home');
        $this->has_output = !$template_found;
    }

    /*
     * Check smarty template used in column.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInColumn()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OCL', 'column');
        $this->has_output = !$template_found;
    }

    /*
     * Check smarty template used in product page.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInProductPage()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OPP', 'productpage');
        $this->has_output = !$template_found;
    }

    /*
     * Check smarty template used in quick view.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInQuickView()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OQV', 'quickview');
        $this->has_output = !$template_found;
    }

    /*
     * Check smarty template used in order page.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInOrderPage()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OOP', 'shoppingcart');
        $this->has_output = !$template_found;
    }

    /*
     * Check smarty template used in ajax cart.
     *
     * @return array
     */
    protected function checkSmartyTemplateUsedInAjaxCart()
    {
        $template_found = LinevenRlpAdminDiagnostic::checkSmartyTemplateUsed('OAC', 'ajaxcart');
        $this->has_output = !$template_found;
    }

    /**
     * Set steps
     *
     * @return void
     */
    public function setSteps()
    {
        parent::setSteps();
        $this->steps[] = array(
            'step' => 'product_image_column',
            'method' => 'checkProductImageUsedInColumn',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check product image used in column', 'Diagnostic'),
                    'error_message' => $this->translator->l('Product image used in column is not a correct product image type. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'product_image_product_page',
            'method' => 'checkProductImageUsedInProductPage',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check product image used in product page', 'Diagnostic'),
                    'error_message' => $this->translator->l('Product image used in product page is not a correct product image type. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'product_image_quickview',
            'method' => 'checkProductImageUsedInQuickView',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check product image used in quick view', 'Diagnostic'),
                    'error_message' => $this->translator->l('Product image used in quick view is not a correct product image type. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'product_image_order_page',
            'method' => 'checkProductImageUsedInOrderPage',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check product image used in order page', 'Diagnostic'),
                    'error_message' => $this->translator->l('Product image used in order page is not a correct product image type. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'product_image_ajax_cart',
            'method' => 'checkProductImageUsedInAjaxCart',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check product image used in ajax cart', 'Diagnostic'),
                    'error_message' => $this->translator->l('Product image used in ajax cart is not a correct product image type. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_homepage',
            'method' => 'checkSmartyTemplateUsedInHomePage',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in home page', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used for home page is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_column',
            'method' => 'checkSmartyTemplateUsedInColumn',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in column', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used in column is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_product_page',
            'method' => 'checkSmartyTemplateUsedInProductPage',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in product page', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used in product page is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_quickview',
            'method' => 'checkSmartyTemplateUsedInQuickView',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in quick view', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used in quick view is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_order_page',
            'method' => 'checkSmartyTemplateUsedInOrderPage',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in order page', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used in order page is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
        $this->steps[] = array(
            'step' => 'template_used_ajax_cart',
            'method' => 'checkSmartyTemplateUsedInAjaxCart',
            'operation' => 'repair',
            'level' => 'warning',
            'repair' => array(
                'is_automatic' => false,
            ),
            'outputs' => array(
                'checking' => array(
                    'progression_text' => $this->translator->l('Check smarty template used in ajax cart', 'Diagnostic'),
                    'error_message' => $this->translator->l('Smarty template used in ajax cart is not exists in folder. Check your configuration.', 'Diagnostic'),
                    'hide_results' => true
                ),
                'target' => 'functional'
            )
        );
    }
}
