<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminHooksController extends LinevenRlpController
{

    /**
     * Init.
     *
     * @return void
     */
    public function init()
    {
        parent::init();
        if ($this->action_name == 'getPluginOptions') {
            $this->presenter->no_layout = true;
        }
    }

    /**
     * Homepage settings action.
     * @return void
     */
    public function onHomepageAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onHomePage', 'hooks:onhomepage');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OHP');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnHomePage();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your homepage settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OHP';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }
    
    /**
     * Column settings action.
     * @return void
     */
    public function onColumnAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onColumn', 'hooks:oncolumn');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OCL');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnColumn();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your column settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OCL';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }

    /**
     * Product page settings action.
     * @return void
     */
    public function onProductPageAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onProductPage', 'hooks:onproductpage');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OPP');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnProductPage();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                // Reconstruct form
                $helper->form = new LinevenRlpFormAdminOnProductPage();
                $helper->form->populateFromConfigurationDatasValue();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your product page settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OPP';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }
    
    /**
     * Product quick view settings action.
     * @return void
     */
    public function onQuickViewAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onQuickView', 'hooks:onquickview');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OQV');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnQuickView();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your quickview settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OQV';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }

    /**
     * Order page settings action.
     * @return void
     */
    public function onOrderPageAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onOrderPage', 'hooks:onorderpage');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OOP');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnOrderPage();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                // Reconstruct form
                $helper->form = new LinevenRlpFormAdminOnOrderPage();
                $helper->form->populateFromConfigurationDatasValue();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your order page settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OOP';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }

    /**
     * Ajax cart settings action.
     * @return void
     */
    public function onAjaxCartAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'onAjaxCart', 'hooks:onajaxcart');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = 'onhook.tpl';

        $presenter = new LinevenRlpPluginAdminOnHookFormPresenter('OAC');
        $presenter->setPluginsToUse();

        $helper->form = new LinevenRlpFormAdminOnAjaxCart();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your ajax cart settings have been updated.', 'Hooks')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $presenter_datas = $presenter->presentUsedPluginsList();
        $presenter_datas['hook_code'] = 'OAC';
        $this->presenter->setDatas($presenter_datas);
        $this->presenter->addOutput('content', $helper->generateForm(null, $presenter_datas));
    }

    /**
     * Link to hook
     * @return void
     */
    public function linkToHookAction()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $return = 0;
        $this->presenter->noRender();
        if (Tools::isSubmit('hook_name') && trim(Tools::getValue('hook_name')) != '') {
            $return = (int)$configuration->getModule()->registerHook(Tools::getValue('hook_name'));
        }
        die(
            json_encode(
                array(
                    'return' => $return
                )
            )
        );
    }

    /**
     * Add plugin action.
     * @return void
     */
    public function addPluginAction()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $this->presenter->noRender();
        $helper = new LinevenRlpHelperForm('Hooks', 'addPlugin', 'hooks:addplugin');
        if (Tools::isSubmit('id_plugin') && (int)Tools::getValue('id_plugin') != 0) {
            $id_plugin = (int)Tools::getValue('id_plugin');
            $presenter = new LinevenRlpPluginAdminOnHookFormPresenter();
            $presenter->setPluginToUse($id_plugin);
            Context::getContext()->smarty->assign($presenter->presentPlugin());
            die(
                Tools::jsonEncode(
                    array(
                        'html' => $configuration->getModule()->display(
                            _PS_MODULE_DIR_.$configuration->getModule()->name,
                            $this->presenter->partial_path_view.'hooks/_plugin.tpl'
                        )
                    )
                )
            );
        }
    }

    /**
     * Get plugin settings action.
     * @return void
     */
    public function getPluginOptionsAction()
    {
        $helper = new LinevenRlpHelperForm('Hooks', 'getPluginOptions', 'hooks:getpluginoptions');
        $helper->base_folder = $this->presenter->path.'hooks/';
        $helper->base_tpl = '_plugin_options.tpl';
        $id_plugin = null;
        $plugin_object = null;
        $plugin_class = null;
        $plugin_options = null;
        if (isset($this->params['id_plugin']) && (int)$this->params['id_plugin'] != 0) {
            $id_plugin = (int)$this->params['id_plugin'];
            $plugin_object = $this->params['plugin_object'];
            $plugin_class = $this->params['plugin_class'];
            $plugin_options = $this->params['plugin_options'];
        }
        if ($plugin_class != null) {
            $helper->form = new LinevenRlpFormAdminPluginOptions($plugin_object, $plugin_class);
            $helper->form->populateOptions($plugin_options);
            $this->presenter->addOutput('content', $helper->generateForm());
        }
    }
}
