<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminPluginsController extends LinevenRlpController
{
    /**
     * List action.
     * @return void
     */
    public function listAction()
    {
        $listing_presenter = new LinevenRlpPluginAdminListingPresenter();
        $plugins_search = new LinevenRlpPluginAdminListingSearch();
        $helper_options = array(
            'show_filters' => false,
            'table_id' => 'lrlp-plugins-list',
            'order_by' => 'order_display',
            'order_way' => 'ASC',
            'reorder_available' => true
        );
        $helper = new LinevenRlpHelperList('Plugins', 'list', 'associations:plugins', $helper_options);
        $helper->identifier = 'id_plugin';
        $helper->title = $this->translator->l('Plugins', 'Plugins');
        $helper->list_id = 'rlp_plugins';
        $helper->addToolbarButton('new', array(
            'href' => LinevenRlpTools::getBackofficeURI('Plugins', 'addEdit', 'associations:plugins:add'),
            'desc' => $this->translator->l('Declare a plugin', 'Plugins')
        ));
        $helper->setActions(array(
            'edit' => LinevenRlpTools::getBackofficeURI('Plugins', 'addEdit', 'associations:plugins:edit'),
            'delete' => LinevenRlpTools::getBackofficeURI('Plugins', 'delete', 'associations:plugins:delete'),
            'enable' => LinevenRlpTools::getBackofficeURI('Plugins', 'activation', 'associations:plugins:activation')
        ));

        // Prepare the generation
        $helper->prepareList($listing_presenter->getFields());
        // Set sort
        $listing_presenter->setAuthorizedSort($helper->isReorderAuthorized());

        // Set messages for action return
        $listing_presenter->setMessage($this->params);
        $listing_presenter->setSubtitleInformationsMessage(
            array(
                $this->translator->l('Plugins definitions (activation, sort, ...) are common for all shops.', 'Plugins'),
                $this->translator->l('You can change plugins sections title or some plugins options (if exists) by editing the plugin.', 'Plugins'),
                '',
                $this->translator->l('Think about your server resources. Select and use plugins with relevance. Each plugin requires the execution of several queries to find and display the products.', 'Plugins'),
                ''
            )
        );
        // Return output
        $this->presenter->setDatas($listing_presenter->present());
        $plugins_search->runQuery($helper->getDisplaySettings());
        $this->presenter->addOutput(LinevenRlpPresenter::$output_type_content, $helper->renderList(
            $listing_presenter->presentList($plugins_search->getResults()),
            $plugins_search->getCount(),
            $this->presenter->getDatas()
        ));
    }
    
    /**
     * Add or edit action.
     * @return void
     */
    public function addEditAction()
    {
        $plugin_presenter = new LinevenRlpPluginAdminPresenter();
        $helper = new LinevenRlpHelperForm('Plugins', 'addEdit', 'associations:plugins:edit');
        $plugin = new LinevenRlpPluginObject();
        $id_plugin = null;
        if (Tools::isSubmit('id_plugin')
            && Tools::getValue('id_plugin') != 0 && Tools::getValue('id_plugin') != '') {
            $id_plugin = Tools::getValue('id_plugin');
            $plugin = new LinevenRlpPluginObject($id_plugin);
        }
        $helper->form = new LinevenRlpFormAdminPlugin($plugin);
        $helper->form->populate($plugin);
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $plugin->populateFromFormValues($helper->form->getFieldsValue());
                $plugin->save();
                $this->presenter->noRender();
                return $this->redirect(
                    'associations:plugins',
                    array('action_return' => array(
                        'action' => 'update',
                        'message' => $this->translator->l('Your plugin has been updated.', 'Plugins')
                    ))
                );
            } else {
                $plugin_presenter->setErrorMessage($helper->form->getErrors());
            }
        }
        $plugin_presenter->setPlugin($plugin);
        $this->presenter->setDatas($plugin_presenter->present());
        $this->presenter->addOutput('content', $helper->generateForm(null, $this->presenter->getDatas()));
        $this->presenter->addOutput('script', '$(".chosen").chosen({width: "280px"});');
    }

    /**
     * Delete action.
     * @return void
     */
    public function deleteAction()
    {
        $this->presenter->noRender();
        if (Tools::isSubmit('id_plugin') && Tools::getValue('id_plugin') != '') {
            $plugin = new LinevenRlpPluginObject(Tools::getValue('id_plugin'));
            if ($plugin->type != LinevenRlpPluginObject::$plugin_type_system) {
                $plugin->delete();
                return $this->redirect(
                    'associations:plugins',
                    array('action_return' => array(
                        'action' => 'delete',
                        'message' => $this->translator->l('Your plugin has been deleted.', 'Plugins')
                    ))
                );
            }
        }
        return $this->redirect(
            'associations:plugins',
            array('action_return' => array(
                'action' => 'delete',
                'type' => LinevenRlpModuleAdminPresenter::$message_type_warning,
                'message' => $this->translator->l('This plugin is a system plugin and can not be deleted.', 'Plugins')
            ))
        );
    }

    /**
     * Activation action.
     * @return void
     */
    public function activationAction()
    {
        $this->presenter->noRender();
        if (Tools::isSubmit('id_plugin') && Tools::getValue('id_plugin') != '') {
            $return = LinevenRlpPluginObject::toggleActivation((int)Tools::getValue('id_plugin'));
            $message = $this->translator->l('activated', 'Plugins');
            if (!$return) {
                $message = $this->translator->l('disabled', 'Plugins');
            }
            $message = sprintf(
                $this->translator->l('Your plugin has been %.', 'Plugins'),
                $message
            );
            return $this->redirect(
                'associations:plugins',
                array('action_return' => array(
                    'action' => 'activation',
                    'message' => $message
                ))
            );
        }
        return false;
    }

    /**
     * Order action.
     * @return void
     */
    public function orderAction()
    {
        $this->presenter->noRender();
        if (Tools::isSubmit('positions') && Tools::isSubmit('first_position') && Tools::isSubmit('last_position')) {
            LinevenRlpPluginObject::order(
                Tools::getValue('positions'),
                Tools::getValue('first_position'),
                Tools::getValue('last_position')
            );
        }
        die();
    }
}
