<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpAdminSettingsController extends LinevenRlpController
{
    /**
     * Module settings action.
     * @return void
     */
    public function moduleAction()
    {
        $helper = new LinevenRlpHelperForm('Settings', 'module', 'settings:module');
        $presenter = new LinevenRlpModuleAdminPresenter();
        $helper->form = new LinevenRlpFormAdminSettings();
        if (LinevenRlpForm::isSubmit()) {
            $helper->form->populateFromRequest();
            if ($helper->form->validate()) {
                $helper->form->updateSettings();
                $presenter->setConfirmationMessage(
                    $this->translator->l('Your module settings have been updated.', 'Settings')
                );
            } else {
                $presenter->setErrorMessage($helper->form->getErrors());
            }
        } else {
            $helper->form->populateFromConfigurationDatasValue();
        }
        $this->presenter->setDatas($presenter->present());
        $this->presenter->addOutput('content', $helper->generateForm());
    }
}
