<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

// Accessories
if (!LinevenRlpPluginObject::isPluginExists('ACCESSORIES')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'ACCESSORIES';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemAccessories';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Accessories',
        'fr' => 'Accessoires',
        'de' => 'Zubehör',
        'es' => 'Accesorios',
        'it' => 'Accessori',
        'pl' => 'Akcesoria',
        'pt' => 'Acessórios'
    ));
    $plugin->title = $plugin->name;
    $plugin->save();
}

// Same category
if (!LinevenRlpPluginObject::isPluginExists('SAME_CATEGORY')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'SAME_CATEGORY';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemCategory';
    $plugin->setOption('USE_DEFAULT_CATEGORY', 1);
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Same category',
        'fr' => 'De même catégorie',
        'de' => 'In der gleichen Kategorie',
        'es' => 'En la misma categoría',
        'it' => 'Nella stessa categoria',
        'pl' => 'W tej samej kategorii',
        'pt' => 'Na mesma categoria'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'In the same category',
        'fr' => 'Dans la même catégorie',
        'de' => 'In der gleichen Kategorie',
        'es' => 'En la misma categoría',
        'it' => 'Nella stessa categoria',
        'pl' => 'W tej samej kategorii',
        'pt' => 'Na mesma categoria'
    ));
    $plugin->save();
}

// Associations
if (!LinevenRlpPluginObject::isPluginExists('ASSOCIATIONS')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'ASSOCIATIONS';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 1;
    $plugin->classname = 'LinevenRlpPluginSystemAssociations';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Associations',
        'fr' => 'Associations',
        'de' => 'Verbände',
        'es' => 'Asociaciones',
        'it' => 'Associazioni',
        'pl' => 'Stowarzyszenia',
        'pt' => 'Associações'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Those products may also interest you',
        'fr' => 'Ces produits sont susceptibles de vous intéresser',
        'de' => 'Diese Produkte könnten Sie interessieren',
        'es' => 'Estos productos pueden interesarle',
        'it' => 'Questi prodotti potrebbero interessarti',
        'pl' => 'Te produkty mogą Cię zainteresować',
        'pt' => 'Esses produtos podem lhe interessar'
    ));
    $plugin->save();
}

// Same brand
if (!LinevenRlpPluginObject::isPluginExists('BRAND')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'BRAND';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemBrand';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Brand',
        'fr' => 'Marque',
        'de' => 'Markierung',
        'es' => 'Marca',
        'it' => 'Marca',
        'pl' => 'Znak',
        'pt' => 'Marca'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'From the same brand',
        'fr' => 'De même marque',
        'de' => 'Von der gleichen Marke',
        'es' => 'De la misma marca',
        'it' => 'Dello stesso marchio',
        'pl' => 'Od tej samej marki',
        'pt' => 'Da mesma marca'
    ));
    $plugin->save();
}

// Same brand and category
if (!LinevenRlpPluginObject::isPluginExists('BRAND_CATEGORY')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'BRAND_CATEGORY';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemBrandCategory';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Brands & categories',
        'fr' => 'Marques & categories',
        'de' => 'Marken & Kategorien',
        'es' => 'Marcas y categorías',
        'it' => 'Marchi e categorie',
        'pl' => 'Marki i kategorie',
        'pt' => 'Marcas & Categorias'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'From the same brand and category',
        'fr' => 'De même marque et catégorie',
        'de' => 'Gleiche Marke und Kategorie',
        'es' => 'Misma marca y categoría',
        'it' => 'Stessa marca e categoria',
        'pl' => 'Ta sama marka i kategoria',
        'pt' => 'Mesma marca e categoria'
    ));
    $plugin->save();
}

// New Products
if (!LinevenRlpPluginObject::isPluginExists('NEW_PRODUCTS')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'NEW_PRODUCTS';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemNewProducts';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'New products',
        'fr' => 'Nouveaux produits',
        'de' => 'Neue Produkte',
        'es' => 'Nuevos productos',
        'it' => 'Nuovi prodotti',
        'pl' => 'Nowe produkty',
        'pt' => 'Novos produtos'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'New products',
        'fr' => 'Nos nouveautés',
        'de' => 'Unsere Neuigkeiten',
        'es' => 'Nuevos productos',
        'it' => 'Nuovi prodotti',
        'pl' => 'Nasze nowe produkty',
        'pt' => 'Novos produtos'
    ));
    $plugin->save();
}

// Also bought
if (!LinevenRlpPluginObject::isPluginExists('ALSO_BOUGHT')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'ALSO_BOUGHT';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemAlsoBought';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Customers who bought this product also bought...',
        'fr' => 'Les clients qui ont acheté ce produit ont également acheté...',
        'de' => 'Kunden, die dieses Produkt gekauft haben, kauften auch...',
        'es' => 'Los clientes que compraron este producto también compraron...',
        'it' => 'I clienti che hanno acquistato questo prodotto hanno anche comprato...',
        'pl' => 'Klienci, którzy kupili ten produkt, kupili również...',
        'pt' => 'Clientes que compraram este produto também compraram ...'
    ));
    $plugin->title = $plugin->name;
    $plugin->save();
}

// Viewed
if (!LinevenRlpPluginObject::isPluginExists('ALREADY_SEEN')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'ALREADY_SEEN';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemAlreadySeen';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Products already seen',
        'fr' => 'Produits déjà consultés',
        'de' => 'Bereits angesehene Produkte',
        'es' => 'Productos ya vistos',
        'it' => 'Prodotti già visualizzati',
        'pl' => 'Produkty już obejrzane',
        'pt' => 'Produtos já visualizados'
    ));
    $plugin->title = $plugin->name;
    $plugin->save();
}

// Products packs
if (!LinevenRlpPluginObject::isPluginExists('PS_PRODUCTS_PACKS')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'PS_PRODUCTS_PACKS';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemInPacks';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Discover our products packs',
        'fr' => 'Découvrez nos packs de produits',
        'de' => 'Entdecken Sie unsere Produktpakete',
        'es' => 'Descubre nuestros paquetes de productos',
        'it' => 'Scopri i nostri pacchetti di prodotti',
        'pl' => 'Odkryj nasze pakiety produktów',
        'pt' => 'Descubra nossos pacotes de produtos'
    ));
    $plugin->title = $plugin->name;
    $plugin->save();
}

// Featured products
if (!LinevenRlpPluginObject::isPluginExists('FEATURED_PRODUCTS')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'FEATURED_PRODUCTS';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemFeaturedProducts';
    $plugin->setOption('ID_CATEGORY', 2);
    $plugin->setOption('USE_DEFAULT_CATEGORY', 1);
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Featured products',
        'fr' => 'Produits phares',
        'de' => 'Flaggschiff-Produkte',
        'es' => 'Productos emblemáticos',
        'it' => 'Prodotti di punta',
        'pl' => 'Produkty flagowe',
        'pt' => 'Produtos emblemáticos'
    ));
    $plugin->title = $plugin->name;
    $plugin->save();
}

// Same supplier
if (!LinevenRlpPluginObject::isPluginExists('SUPPLIER')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'SUPPLIER';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemSupplier';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Supplier',
        'fr' => 'Fournisseur',
        'de' => 'Versorger',
        'es' => 'Proveedor',
        'it' => 'Fornitore',
        'pl' => 'Dostawca',
        'pt' => 'Provedor'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'From the same supplier',
        'fr' => 'De même fournisseur',
        'de' => 'Vom selben Lieferanten',
        'es' => 'Del mismo proveedor',
        'it' => 'Dallo stesso fornitore',
        'pl' => 'Od tego samego dostawcy',
        'pt' => 'Do mesmo fornecedor'
    ));
    $plugin->save();
}

// Best sales
if (!LinevenRlpPluginObject::isPluginExists('BEST_SALES')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'BEST_SALES';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->classname = 'LinevenRlpPluginSystemBestSales';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Best sales',
        'fr' => 'Meilleures ventes',
        'de' => 'Bestseller',
        'es' => 'Los mas vendidos',
        'it' => 'I più venduti',
        'pl' => 'Bestsellery',
        'pt' => 'Mais vendidos'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Best sales',
        'fr' => 'Meilleures ventes',
        'de' => 'Bestseller',
        'es' => 'Los mas vendidos',
        'it' => 'I più venduti',
        'pl' => 'Bestsellery',
        'pt' => 'Mais vendidos'
    ));
    $plugin->save();
}

// Highlighting a brand
if (!LinevenRlpPluginObject::isPluginExists('HIGHLIGHT_BRAND')) {
    $plugin = new LinevenRlpPluginObject();
    $plugin->code = 'HIGHLIGHT_BRAND';
    $plugin->type = LinevenRlpPluginObject::$plugin_type_system;
    $plugin->is_active = 0;
    $plugin->setOption('ID_BRAND', 1);
    $plugin->classname = 'LinevenRlpPluginSystemHighlightingBrand';
    $plugin->name = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Discover our new brand',
        'fr' => 'Découvrez notre nouvelle marque',
        'de' => 'Entdecken Sie unsere neue Marke',
        'es' => 'Descubre nuestra nueva marca',
        'it' => 'Scopri il nostro nuovo marchio',
        'pl' => 'Odkryj naszą nową markę',
        'pt' => 'Descubra a nossa nova marca'
    ));
    $plugin->title = LinevenRlpTranslator::setDefaultTranslationsInArray(array(
        'en' => 'Discover our new brand',
        'fr' => 'Découvrez notre nouvelle marque',
        'de' => 'Entdecken Sie unsere neue Marke',
        'es' => 'Descubre nuestra nueva marca',
        'it' => 'Scopri il nostro nuovo marchio',
        'pl' => 'Odkryj naszą nową markę',
        'pt' => 'Descubra a nossa nova marca'
    ));
    $plugin->save();
}

// Reorder
LinevenRlpPluginObject::reorder();
