<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/config/config.inc.php');

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class RelatedProducts extends LinevenRlpModule implements WidgetInterface
{
    public static $template_standard_classic          = 'CLASSIC';       /* Standard template classic */
    public static $template_standard_list_a           = 'LIST_A';        /* Standard template Model A*/
    public static $template_standard_list_b           = 'LIST_B';        /* Standard template Model B*/
    public static $template_standard_thumbnails       = 'THUMBNAILS';    /* Standard template Thumbnails */
    public static $template_standard_theme            = 'THEME';         /* Standard template Theme */

    public static $displaying_column_left             = 'LEFT';            /* Left */
    public static $displaying_column_right            = 'RIGHT';           /* Right */

    public static $product_visibility_both            = 'both';            /* Both */
    public static $product_visibility_catalog         = 'catalog';         /* Catalog */
    public static $product_visibility_search          = 'search';          /* Search */
    public static $product_visibility_none            = 'none';            /* None */
    
    public static $rules_keywords_reference           = 'reference';       /* Reference */
    public static $rules_keywords_name                = 'name';            /* Name */
    public static $rules_keywords_description         = 'description';     /* Description */
    
    public static $product_page_hook_use_footer       = 'FOOTER';          /* Footer */
    public static $product_page_hook_use_section      = 'SECTION';         /* Section */
    public static $product_page_hook_use_tab          = 'TAB';             /* Tab */
    public static $shoppingcart_page_hook_use_footer  = 'FOOTER';          /* Footer */
    public static $hook_to_use_specific               = 'SPECIFIC';        /* Specific hook */

    public static $refresh_method_nothing           = 'NOTHING';
    public static $refresh_method_reload            = 'RELOAD';
    public static $refresh_method_ajax              = 'AJAX';

    public static $sort_display_default             = 'DEFAULT';
    public static $sort_display_name                = 'NAME';
    public static $sort_display_price               = 'PRICE';
    public static $sort_display_random              = 'RANDOM';

    public static $sort_way_asc                     = 'asc';
    public static $sort_way_desc                    = 'desc';

    public static $partner_reviews_module_lineven     = 'homecomments';
    public static $partner_reviews_module_prestashop  = 'productcomments';
    public static $partner_reviews_module_hook        = 'hook';

    public static $hook_code_homepage       = 'OHP';
    public static $hook_code_column         = 'OCL';
    public static $hook_code_product        = 'OPP';
    public static $hook_code_quickview      = 'OQV';
    public static $hook_code_order          = 'OOP';
    public static $hook_code_ajaxcart       = 'OAC';

    public static $plugins = array();           // Plugins
    public static $is_plugin_loaded = false;    // Plugins loaded
    public static $native_templates;

    /**
     * Constructor.
     * @return void
     */
    public function __construct()
    {
        $this->name = 'relatedproducts';
        $this->tab = 'merchandizing';
        $this->version = '3.0.2';
        $this->need_instance = 0;
        $this->author = 'Lineven';
        $this->module_key = '355446d1eb9b75477e2d00a49088a410';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->bootstrap = true;
        
        parent::__construct();

        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Related Products - Cross selling All in One', 'relatedproducts');
        $this->description = $this->l('Increase your sales by incentives purchases (cross selling) using plugins and customized associations (products, categories, keywords, ...) based on the products consulted, the customer cart and orders.', 'relatedproducts');
        $this->confirmUninstall = $this->l('Are you sure you want to delete your details ?', 'relatedproducts');

        // Context
        $this->module_context->setEnvironment(LinevenRlpContext::$environment_production);

        // Configuration
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $configuration->setup(
            'RLP',
            '7942',
            $this
        );
    }

    /**
     * Init.
     * @param boolean $force Force initialization
     *
     * @return void
     */
    public function init($force = false)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        if (!$this->isInit()) {
            if ($this->module_context->getApplication() == LinevenRlpContext::$application_backoffice) {
                // Load backoffice settings
                $configuration->setBackofficeSettings(array(
                    'is_install_files' => true,
                    'is_backoffice_menu_available' => true
                ));
            }
            // Parent initialization
            parent::init($force);

            // Templates
            self::$native_templates = array(
                self::$template_standard_classic => $this->l('Classic', 'relatedproducts'),
                self::$template_standard_list_a => $this->l('List (Model A)', 'relatedproducts'),
                self::$template_standard_list_b => $this->l('List (Model B)', 'relatedproducts'),
                self::$template_standard_thumbnails => $this->l('Thumbnails', 'relatedproducts'),
                self::$template_standard_theme => $this->l('Theme', 'relatedproducts')
            );

            // Specific initialization
            // Add partners
            LinevenRlpPartners::addPartner(
                self::$partner_reviews_module_lineven,
                'Lineven',
                self::$partner_reviews_module_lineven,
                'Go Reviews - Reviews, Advices, Ratings, SEO and Google Rich Snippets',
                '1.3.7',
                '1.4.0.5'
            );

            // Add partners
            LinevenRlpPartners::addPartner(
                self::$partner_reviews_module_prestashop,
                'Lineven',
                self::$partner_reviews_module_prestashop,
                'Prestashop - Product Comments',
                '4.0.0',
                '1.7.6.0'
            );

            $this->initializated();
        }
    }

    /**
     * Install.
     * @see ModuleCore::install()
     * @return boolean
     */
    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        // Install plugins
        require_once(dirname(__FILE__).'/install/plugins.inc.php');
        return true;
    }

    /**
     * Get plugins
     */
    public static function getPlugins()
    {
        // Get plugins
        if (!RelatedProducts::$is_plugin_loaded) {
            $plugins = LinevenRlpPluginObject::getPlugins(true, true);
            RelatedProducts::$plugins = array();
            if ($plugins) {
                $plugins = ObjectModel::hydrateCollection(
                    'LinevenRlpPluginObject',
                    $plugins
                );
                foreach ($plugins as $plugin) {
                    RelatedProducts::$plugins[$plugin->code] = $plugin;
                }
            }
            RelatedProducts::$is_plugin_loaded = true;
        }
        return RelatedProducts::$plugins;
    }

    /**
     * Set media for backoffice.
     *
     * @return void
     */
    public static function setBackofficeMedia()
    {
        parent::setBackofficeMedia();
        // Add JQuery Plugin
        Context::getContext()->controller->addjQueryPlugin(array(
            'sortable'
        ));
    }

    /**
     * Hook admin set media.
     * @param array $params
     * @return void / object
     */
    public function hookActionAdminControllerSetMedia($params)
    {
        $this->module_context->setApplication(LinevenRlpContext::$application_backoffice);
        $this->init();
        $controller = LinevenRlpController::getController('Media', LinevenRlpController::$controller_type_admin_hook);
        $controller->params = $params;
        return $controller->run();
    }

    /**
     * Hook admin backoffice header.
     * @param array $params
     * @return void / object
     */
    public function hookDisplayBackOfficeHeader($params)
    {
        $this->module_context->setApplication(LinevenRlpContext::$application_backoffice);
        $this->init();
        $controller = LinevenRlpController::getController('Header', LinevenRlpController::$controller_type_admin_hook);
        $controller->params = $params;
        return $controller->run();
    }

    /**
     * Hook Header.
     * @param array $params
     * @return void / object
     */
    public function hookHeader($params)
    {
        $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
        $this->init();
        $controller = LinevenRlpController::getController('Header', LinevenRlpController::$controller_type_front_hook);
        $controller->params = $params;
        return $controller->run();
    }

    /**
     * Hook Home.
     * @param Object $params
     * @return object
     */
    public function hookHome($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_HOME')) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('Home', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run();
        }
    }

    /**
     * Hook Column left.
     * @param Object $params
     * @return object
     */
    public function hookLeftColumn($params)
    {
        if (Configuration::get('LINEVEN_RLP_OCL_WITCH') == self::$displaying_column_left) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('Column', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run();
        }
        return null;
    }

    /**
     * Hook Column right.
     * @param Object $params
     * @return object
     */
    public function hookRightColumn($params)
    {
        if (Configuration::get('LINEVEN_RLP_OCL_WITCH') == self::$displaying_column_right) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('Column', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run();
        }
        return null;
    }

    /**
     * Hook Product Additional info.
     *
     * @param Object $params
     * @return void / object
     */
    public function hookDisplayProductAdditionalInfo($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_QUICKVIEW') &&
            Tools::isSubmit('action') &&  Tools::getValue('action') == 'quickview') {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('QuickView', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run();
        }
    }

    /**
     * Hook Product Quick view.
     *
     * @param Object $params
     * @return void / object
     */
    public function hookDisplayRelatedProductsQuickView($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_QUICKVIEW') &&
            Tools::isSubmit('action') &&  Tools::getValue('action') == 'quickview') {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('QuickView', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run();
        }
    }

    /**
     * Hook ProductFooter.
     * @param Object $params
     * @return object
     */
    public function hookProductFooter($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER') &&
            !(Tools::isSubmit('action') &&  Tools::getValue('action') == 'quickview') &&
            (Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') === false ||
            Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') == '' ||
            Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') == self::$product_page_hook_use_footer)) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('ProductPage', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run('footer');
        }
    }

    /**
     * Hook Product extra content.
     * @param Object $params
     * @return object
     */
    public function hookDisplayProductExtraContent($params)
    {
        if (!(Tools::isSubmit('action') &&  Tools::getValue('action') == 'quickview') &&
            Configuration::get('LINEVEN_RLP_HOOK_PRODUCTFOOTER') &&
            Configuration::get('LINEVEN_RLP_OPP_HOOK_USE') == self::$product_page_hook_use_tab) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('ProductPage', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            $presenter = null;
            if (!Configuration::get('LINEVEN_RLP_OPP_IS_ASYNC')) {
                $presenter = $controller->run('extraContentPrepare');
            } else {
                $presenter = $controller->run('extraContentPrepareAsync');
            }
            $array = array();
            if ($presenter) {
                $presenter_datas = $presenter->present();
                if (is_array($presenter_datas) && isset($presenter_datas['sections']) && count($presenter_datas['sections'])) {
                    foreach ($presenter_datas['sections'] as $section_key => $section) {
                        $controller->params['extracontent_presenter'] = $presenter;
                        $controller->params['extracontent_presenter_datas'] = $presenter_datas;
                        $controller->params['extracontent_section_key'] = $section_key;
                        $controller->params['extracontent_section'] = $section;
                        if ((isset($section['products']) && count($section['products'])) || Configuration::get('LINEVEN_RLP_OPP_IS_ASYNC')) {
                            $title = $presenter_datas['title'];
                            if ($presenter_datas['is_separate_results']) {
                                $title = $section['title'];
                            }
                            $html = $controller->run('extraContentOutput');
                            if ($html) {
                                $array[] = (new PrestaShop\PrestaShop\Core\Product\ProductExtraContent())
                                    ->setTitle($title)
                                    ->setContent($html);
                            }
                        }
                    }
                    return $array;
                }
            }
        }
        return array();
    }

    /**
     * Hook ShoppingCart.
     * @param Object $params
     * @return object
     */
    public function hookShoppingCart($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_SHOPPINGCART') &&
            (Configuration::get('LINEVEN_RLP_OOP_HOOK_USE') === false ||
                Configuration::get('LINEVEN_RLP_OOP_HOOK_USE') == '' ||
                Configuration::get('LINEVEN_RLP_OOP_HOOK_USE') == self::$shoppingcart_page_hook_use_footer)) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('ShoppingCart', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run('shoppingCart');
        }
    }

    /**
     * Hook AjaxCart.
     * @param Object $params
     * @return object
     */
    public function hookDisplayRelatedProductsAjaxCart($params)
    {
        if (Configuration::get('LINEVEN_RLP_HOOK_AJAXCART')) {
            $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
            $this->init();
            $controller = LinevenRlpController::getController('AjaxCart', LinevenRlpController::$controller_type_front_hook);
            $controller->params = $params;
            return $controller->run('ajaxCart');
        }
    }

    public function renderWidget($hook_name, array $params)
    {
        if ($this->module_context->isModuleActive() && Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF')) {
            $controller_name = '';
            $hooks_def = unserialize(Configuration::get('LINEVEN_RLP_SPECIFIC_HOOK_DEF'));
            if (is_array($hooks_def) && array_key_exists($hook_name, $hooks_def)) {
                $controller_name = $hooks_def[$hook_name];
            }
            if ($controller_name != '') {
                $this->module_context->setApplication(LinevenRlpContext::$application_frontoffice);
                $this->init();
                $controller = LinevenRlpController::getController($controller_name, LinevenRlpController::$controller_type_front_hook);
                $controller->params = $params;
                return $controller->run('widget');
            }
        }
        return false;
    }

    public function getWidgetVariables($hook_name, array $params)
    {
    }
}
