<?php
/**
 * Library for Lineven Prestashop Modules (Version 4.1.3)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpModuleAlerts
{
    /**
     * Check for alerts.
     *
     * @return array
     */
    public static function getAlerts()
    {
        $module_context = LinevenRlpContext::getContext();
        $translator = new LinevenRlpTranslator();
        $return = array();
        $alert = array();
        
        // Is Test mode active
        if ($module_context->isTestModeActive()) {
            $alert['icon'] = 'fa fa-moon-o';
            $alert['message'] =
                $translator->l('The test mode is active. Click to inactive.', 'Alerts');
            $alert['color'] = '#D2A63C';
            $alert['on_click'] = 'LinevenRlp.Tools.toggleStatus(\'test_mode\')';
            $return[] = $alert;
        } else {
            if (!$module_context->isModuleActive()) {
                $alert['icon'] = 'fa fa-times-circle';
                $alert['message'] =
                    $translator->l('The module is disabled. Click to active.', 'Alerts');
                $alert['color'] = '#D27C82';
                $alert['on_click'] = 'LinevenRlp.Tools.toggleStatus(\'active_module\')';
                $return[] = $alert;
            }
        }

        // Check hooks
        $items = LinevenRlpModuleDiagnostic::checkHooks();
        if (count($items) != 0) {
            $alert['icon'] = 'fa fa-exclamation-triangle';
            $alert['message'] =
            $translator->l('This module does not seem to be associated to hooks : ', 'Alerts');
            $alert['items'] = $items;
            $alert['label_fix'] = $translator->l('Click here to repair', 'Alerts');
            $alert['on_click'] = 'LinevenRlp.Diagnostic.execute(\'hooks\', true)';
            $return[] = $alert;
        }
        
        return $return;
    }
}
