<?php
/**
 * Library for Lineven Prestashop Modules (Version 4.1.3)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpModuleUpgradeController extends LinevenRlpController
{

    /**
     * Upgrade module action.
     *
     * @return void
     */
    public function upgradeModuleAction()
    {
        $this->presenter->noRender();
        $return = array(
            'is_upgrades' => false,
            'is_upgrades_complete' => true,
            'upgrades_count' => 0,
            'upgrades_step_progress' => 0,
            'version' => ''
        );
        if (LinevenRlpModuleUpgrade::isExtraUpgrade()) {
            $upgrades = LinevenRlpModuleUpgrade::getUpgrades();
            $version = $upgrades[0];
            $return = array(
                'is_upgrades' => true,
                'is_upgrades_complete' => false,
                'upgrades_count' => count($upgrades),
                'upgrades_step_progress' => round(100/count($upgrades), 2),
                'version' => $version
            );
        }
        die(json_encode($return));
    }

    /**
     * Launch action.
     *
     * @return void
     */
    public function upgradeVersionAction()
    {
        $this->presenter->noRender();
        if (Tools::isSubmit('version') && Tools::getValue('version') != '' &&
            file_exists(_PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/upgrade/install-'.
            Tools::getValue('version').'.php')) {
            require(_PS_MODULE_DIR_ . _LINEVEN_MODULE_RLP_DIRNAME_ . '/upgrade/install-' .
                Tools::getValue('version') . '.php');
            $function_name = 'extra_upgrade_module_'.str_replace('.', '_', Tools::getValue('version'));
            if (function_exists($function_name)) {
                call_user_func($function_name);
            }
        }
        die();
    }
}
