<?php
/**
 * Library for Lineven Prestashop Modules (Version 4.1.3)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpModuleAdminListingPresenter extends LinevenRlpModuleAdminPresenter
{
    protected $auhorized_order;
    protected $subtitle_informations_message;

    /**
     * Constructor.
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->auhorized_order = false;
        $this->subtitle_informations_message = false;
    }

    /**
     * Set authorized sort.
     * @param boolean $allow Allow sort
     * @return void
     */
    public function setAuthorizedSort($allow)
    {
        $this->auhorized_order = $allow;
    }

    /**
     * Set subtitles informations message.
     * @param string $message Message
     * @return void
     */
    public function setSubtitleInformationsMessage($message)
    {
        $this->subtitle_informations_message = $message;
    }

    /**
     * Present.
     * @return array
     */
    public function present()
    {
        parent::present();
        $this->presenter['authorized_order'] = $this->auhorized_order;
        $this->presenter['subtitle_informations_message'] = $this->subtitle_informations_message;
        return $this->presenter;
    }
}
