<?php
/**
 * Library for Lineven Prestashop Modules (Version 4.1.3)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

class LinevenRlpModuleUpgrade
{
    /**
     * Get upgrades.
     */
    public static function getUpgrades()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        if (Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') !== false &&
            Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') != null) {
            return unserialize(Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE'));
        }
        return false;
    }

    /**
     * Is extra upgrade.
     */
    public static function isExtraUpgrade()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        if (Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') !== false &&
            Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') != null) {
            if (self::getUpgrades()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Add version.
     * @param string $version Version
     */
    public static function addVersion($version)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        $upgrade_versions = array();
        if (Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') !== false &&
            Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') != null) {
            $upgrade_versions = unserialize(Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE'));
            $upgrade_versions[] = $version;
        }
        $upgrade_versions[] = $version;
        Configuration::updateGlobalValue($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE', serialize($upgrade_versions));
    }

    /**
     * Delete version.
     * @param string $version Version
     */
    public static function deleteVersion($version)
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        if (Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') !== false &&
            Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE') != null) {
            $upgrade_versions = unserialize(Configuration::get($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE'));
            if (($key = array_search($version, $upgrade_versions)) !== false) {
                unset($upgrade_versions[$key]);
            }
            if (count($upgrade_versions)) {
                Configuration::updateGlobalValue($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE', serialize($upgrade_versions));
            } else {
                self::clear();
            }
        }
    }

    /**
     * Clear all version upgrade.
     * @param string $version Version
     */
    public static function clear()
    {
        $configuration = LinevenRlpConfiguration::getConfiguration();
        Configuration::updateGlobalValue($configuration->getPrefixConfigurationModule().'EXTRA_UPGRADE', null);
    }
}
