<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

function upgrade_module_1_1_0()
{
    if (Configuration::get('LINEVEN_RLP_RAMDOMIZE') === false) {
        Configuration::updateValue('LINEVEN_RLP_RAMDOMIZE', 0);
    }
    
    // Database
    if (! file_exists(dirname(__FILE__).'/upgrade-1.1.0.sql')) {
        return (false);
    } else if (! $sql = Tools::file_get_contents(dirname(__FILE__).'/upgrade-1.1.0.sql')) {
        return (false);
    }
    $sql = str_replace('PREFIX_', _DB_PREFIX_, $sql);
    if (_PS_VERSION_ >= 1.4) {
        $sql = str_replace('MYSQL_ENGINE', _MYSQL_ENGINE_, $sql);
    } else {
        $sql = str_replace('MYSQL_ENGINE', 'MyISAM', $sql);
    }
    $sql = preg_split('/;\s*[\r\n]+/', $sql);

    foreach ($sql as $query) {
        Db::getInstance()->Execute(trim($query));
    }
    return true;
}
