<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_1_2_0()
{
    Configuration::updateValue('LINEVEN_RLP_SUPPORT_DOJO_VRS', '1.9.1');

    if (Configuration::get('LINEVEN_RLP_INCLUDE_ORDERS') === false) {
        Configuration::updateValue('LINEVEN_RLP_INCLUDE_ORDERS', 0);
    }
    if (Configuration::get('LINEVEN_RLP_INCLUDE_VIEWED') === false) {
        Configuration::updateValue('LINEVEN_RLP_INCLUDE_VIEWED', 0);
    }

    // New configuration
    $max_product = Configuration::get('LINEVEN_RLP_MAX_PRODUCTS');
    $image_type = Configuration::get('LINEVEN_RLP_IMAGE_TYPE');
    $desc_height = Configuration::get('LINEVEN_RLP_DESC_HEIGHT');
    $displaying_mode = Configuration::get('LINEVEN_RLP_DISPLAYING_MODE');
    $displaying_price = Configuration::get('LINEVEN_RLP_DISPLAYING_PRICE');
    $displaying_cart = Configuration::get('LINEVEN_RLP_DISPLAYING_CART');
    $display_title = Configuration::get('LINEVEN_RLP_THUMB_DISPLAY_TITLE');
    $display_desc = Configuration::get('LINEVEN_RLP_THUMB_DISPLAY_DESC');

    Configuration::updateValue('LINEVEN_RLP_OPP_MAX_PRODUCTS', $max_product);
    Configuration::updateValue('LINEVEN_RLP_OPP_DISPLAYING_MODE', $displaying_mode);
    Configuration::updateValue('LINEVEN_RLP_OPP_IMAGE_TYPE', $image_type);
    Configuration::updateValue('LINEVEN_RLP_OPP_DISPLAY_PRICE', $displaying_price);
    Configuration::updateValue('LINEVEN_RLP_OPP_DISPLAY_CART', $displaying_cart);
    Configuration::updateValue('LINEVEN_RLP_OPP_THUMB_DP_TITLE', $display_title);
    Configuration::updateValue('LINEVEN_RLP_OPP_THUMB_DP_DESC', $display_desc);
    Configuration::updateValue('LINEVEN_RLP_OPP_THUMB_DP_HEIGHT', $desc_height);
    Configuration::updateValue('LINEVEN_RLP_OHP_MAX_PRODUCTS', $max_product);
    Configuration::updateValue('LINEVEN_RLP_OHP_DISPLAY_PRICE', $displaying_price);
    Configuration::updateValue('LINEVEN_RLP_OHP_DISPLAY_CART', $displaying_cart);
    Configuration::updateValue('LINEVEN_RLP_OOP_MAX_PRODUCTS', $max_product);
    Configuration::updateValue('LINEVEN_RLP_OOP_DISPLAYING_MODE', $displaying_mode);
    Configuration::updateValue('LINEVEN_RLP_OOP_IMAGE_TYPE', $image_type);
    Configuration::updateValue('LINEVEN_RLP_OOP_DISPLAY_PRICE', $displaying_price);
    Configuration::updateValue('LINEVEN_RLP_OOP_DISPLAY_CART', $displaying_cart);
    Configuration::updateValue('LINEVEN_RLP_OOP_THUMB_DP_TITLE', $display_title);
    Configuration::updateValue('LINEVEN_RLP_OOP_THUMB_DP_DESC', $display_desc);
    Configuration::updateValue('LINEVEN_RLP_OOP_THUMB_DP_HEIGHT', $desc_height);

    Configuration::deleteByName('LINEVEN_RLP_MAX_PRODUCTS');
    Configuration::deleteByName('LINEVEN_RLP_IMAGE_TYPE');
    Configuration::deleteByName('LINEVEN_RLP_DESC_HEIGHT');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAYING_MODE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAYING_PRICE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAYING_CART');
    Configuration::deleteByName('LINEVEN_RLP_THUMB_DISPLAY_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_THUMB_DISPLAY_DESC');

    return true;
}
