<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_1_2_6()
{
    Configuration::updateValue('LINEVEN_RLP_ACCESS_TO_LIST', 0);
    Configuration::updateValue('LINEVEN_RLP_OHP_IMAGE_TYPE', '1');
    Configuration::updateValue('LINEVEN_RLP_HOOK_COLUMN', 0);
    Configuration::updateValue('LINEVEN_RLP_OCL_IMAGE_TYPE', '1');
    Configuration::updateValue('LINEVEN_RLP_OCL_MAX_PRODUCTS', 5);
    Configuration::updateValue('LINEVEN_RLP_OCL_WITCH', 'LEFT');

    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();

    // Hooks
    if (_PS_VERSION_ >= '1.5') {
        $module->registerHook('displayRightColumn');
        $module->registerHook('displayLeftColumn');
    } else {
        $module->registerHook('rightColumn');
        $module->registerHook('leftColumn');
    }

    if (_PS_VERSION_ >= '1.5') {
        Configuration::updateGlobalValue('LINEVEN_RLP_DOJO_VERSION', '');
    } else {
        Configuration::updateValue('LINEVEN_RLP_DOJO_VERSION', '');
    }
    // Clean
    if (Configuration::get('LINEVEN_RLP_SUPPORT_IS_DEBUG')) {
        Configuration::updateValue('LINEVEN_RLP_IS_DEBUG_MODE', Configuration::get('LINEVEN_RLP_SUPPORT_IS_DEBUG'));
        Configuration::deleteByName('LINEVEN_RLP_SUPPORT_IS_DEBUG');
    }
    if (Configuration::get('LINEVEN_RLP_SUPPORT_TOOLTIP')) {
        if (_PS_VERSION_ >= '1.5') {
            Configuration::updateGlobalValue('LINEVEN_RLP_HELP_TOOLTIP', Configuration::get('LINEVEN_RLP_SUPPORT_TOOLTIP'));
        } else {
            Configuration::updateValue('LINEVEN_RLP_HELP_TOOLTIP', Configuration::get('LINEVEN_RLP_SUPPORT_TOOLTIP'));
        }
        Configuration::deleteByName('LINEVEN_RLP_SUPPORT_TOOLTIP');
    }

    if (Configuration::get('LINEVEN_RLP_SUPPORT_DOJO_VRS')) {
        Configuration::deleteByName('LINEVEN_RLP_SUPPORT_DOJO_VRS');
    }
    if (Configuration::get('LINEVEN_RLP_DOJO_BO_ACTIVE') === false) {
        if (_PS_VERSION_ >= '1.5') {
            Configuration::updateGlobalValue('LINEVEN_RLP_DOJO_BO_ACTIVE', 1);
        } else {
            Configuration::updateValue('LINEVEN_RLP_DOJO_BO_ACTIVE', 1);
        }
    }

    if (Configuration::get('LINEVEN_RLP_DOJO_FO_ACTIVE') === false) {
        if (_PS_VERSION_ >= '1.5') {
            Configuration::updateGlobalValue('LINEVEN_RLP_DOJO_FO_ACTIVE', 0);
        } else {
            Configuration::updateValue('LINEVEN_RLP_DOJO_FO_ACTIVE', 0);
        }
    }

    // Old configurations
    if (Configuration::get('LINEVEN_RLP_SUPPORT_KEY')) {
        Configuration::deleteByName('LINEVEN_RLP_SUPPORT_KEY');
    }
    if (Configuration::get('LINEVEN_RLP_SUPPORT_CODE')) {
        Configuration::deleteByName('LINEVEN_RLP_SUPPORT_CODE');
    }
    // Clean old directory if exists
    //LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/classes');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/public/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/help');

    // Clean files
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/config/backward.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/config/backward.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Support.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Support.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/Context.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/Context.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/controller/Help.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/controller/Help.php');
    }
    if (_PS_VERSION_ >= '1.5') {
        Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.2.6');
    } else {
        Configuration::updateValue('LINEVEN_RLP_LAST_VERSION', '1.2.6');
    }
    return true;
}
