<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_1_2_8()
{
    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();

    if (_PS_VERSION_ >= '1.5') {
        $module->registerHook('displayProductTab');
        $module->registerHook('displayProductTabContent');
    } else {
        $module->registerHook('productTab');
        $module->registerHook('productTabContent');
    }
    
    // Configuration
    Configuration::updateValue('LINEVEN_RLP_INCLUDE_CART', 1);
    Configuration::updateValue('LINEVEN_RLP_COMBINATIONS_ALL', 0);
    Configuration::updateValue('LINEVEN_RLP_COMBINATIONS_ADDCART', 0);
    Configuration::updateValue('LINEVEN_RLP_COMBINATIONS_DSP_OPT', 0);
    Configuration::updateValue('LINEVEN_RLP_AVL_ZERO_QTY', 1);
    Configuration::updateValue('LINEVEN_RLP_AVL_VISIBILITY', serialize(array('both', 'catalog', 'search')));
    Configuration::updateValue('LINEVEN_RLP_OPP_HOOK_USE', 'FOOTER');
    Configuration::updateValue(
        'LINEVEN_RLP_KW_RULES_DFLT',
        serialize(array(
            'name' => 1,
            'description' => 0,
            'reference' => 0
        ))
    );
    Configuration::updateValue('LINEVEN_RLP_PARTNER_RVW_MODULE', 'productcomments');
    if (LinevenRlpPartners::verifyModule(RelatedProducts::$partner_reviews_module_lineven)) {
        Configuration::updateValue('LINEVEN_RLP_PARTNER_RVW_MODULE', 'homecomments');
    }
    
    // Update editorial
    $languages = Language::getLanguages(true);
    $section_title = array();
    foreach ($languages as $language) {
        if (Configuration::get('LINEVEN_RLP_TITLE', $language['id_lang']) !== false) {
            $section_title[$language['id_lang']] = Configuration::get('LINEVEN_RLP_TITLE', $language['id_lang']);
        }
    }
    Configuration::updateValue('LINEVEN_RLP_OPP_TITLE', $section_title);
    Configuration::updateValue('LINEVEN_RLP_OCL_TITLE', $section_title);
    Configuration::updateValue('LINEVEN_RLP_OOP_TITLE', $section_title);
    Configuration::updateValue('LINEVEN_RLP_OHP_TITLE', $section_title);
    if (version_compare(_PS_VERSION_, '1.6', '>=')
        && Configuration::get('LINEVEN_RLP_OHP_IN_TAB')) {
        // Initialize messages
        $default_home_title_translations = array('en' => 'So more', 'fr' => 'Voir plus');
        $home_title_translations = array((int)Configuration::get('PS_LANG_DEFAULT') => $module->l('So more', 'install-1.2.8'));
        foreach (Language::getLanguages(false) as $language) {
            if (isset($default_home_title_translations[$language['iso_code']])) {
                $home_title_translations[(int)$language['id_lang']] = $default_home_title_translations[$language['iso_code']];
            } else {
                $home_title_translations[(int)$language['id_lang']] = $default_home_title_translations['en'];
            }
        }
        Configuration::updateValue('LINEVEN_RLP_OHP_TITLE', $home_title_translations);
    }
    Configuration::deleteByName('LINEVEN_RLP_TITLE');
    if (Configuration::get('LINEVEN_RLP_OHP_HOME_TAB') !== false) {
        Configuration::deleteByName('LINEVEN_RLP_OHP_HOME_TAB');
    }
    
    // Database
    if (! file_exists(dirname(__FILE__).'/upgrade-1.2.8.sql')) {
        return (false);
    } else if (! $sql = Tools::file_get_contents(dirname(__FILE__).'/upgrade-1.2.8.sql')) {
        return (false);
    }
    $sql = str_replace('PREFIX_', _DB_PREFIX_, $sql);
    if (_PS_VERSION_ >= 1.4) {
        $sql = str_replace('MYSQL_ENGINE', _MYSQL_ENGINE_, $sql);
    } else {
        $sql = str_replace('MYSQL_ENGINE', 'MyISAM', $sql);
    }
    $sql = preg_split('/;\s*[\r\n]+/', $sql);
    
    foreach ($sql as $query) {
        Db::getInstance()->Execute(trim($query));
    }
    
    // Icon for PS 1.6
    if (version_compare(_PS_VERSION_, '1.6.1.2', '>=')) {
        copy(
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/views/img/logo57.png',
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/logo.png'
        );
    } else {
        copy(
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/views/img/logo32.png',
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/logo.png'
        );
    }
    
    // Clean files
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Displaying.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Displaying.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/content/settings/displaying.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/content/settings/displaying.php');
    }
    
    if (_PS_VERSION_ >= '1.5') {
        Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
        Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.2.8');
    } else {
        Configuration::updateValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
        Configuration::updateValue('LINEVEN_RLP_LAST_VERSION', '1.2.8');
    }
    return true;
}
