<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

function upgrade_module_1_2_9()
{
    // Configuration
    Configuration::updateValue('LINEVEN_RLP_SAME_CATEGORY', 0);
    

    // Icon for PS 1.6
    if (version_compare(_PS_VERSION_, '1.6.1.2', '>=')) {
        copy(
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/views/img/logo57.png',
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/logo.png'
        );
    } else {
        copy(
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/views/img/logo32.png',
            _PS_MODULE_DIR_._LINEVEN_MODULE_RLP_DIRNAME_.'/logo.png'
        );
    }
    
    // Delete files
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/library/tab/');
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/GenericHook.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/GenericHook.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/services/Installation.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/services/Installation.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/services/QuickLinks.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/services/QuickLinks.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/services/Settings.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/services/Settings.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/services/Stores.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/services/Stores.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/services/Support.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/services/Support.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/controller/FrontController.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/controller/FrontController.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/controller/ModuleFrontController_1_3.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/controller/ModuleFrontController_1_3.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/controller/ModuleFrontController_1_4.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/controller/ModuleFrontController_1_4.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/view/FrontView.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/view/FrontView.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/Controller.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/Controller.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/Controller.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/Controller.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/Model.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/Model.php');
    }
    if (file_exists(_PS_MODULE_DIR_.'/relatedproducts/library/Service.php')) {
        unlink(_PS_MODULE_DIR_.'/relatedproducts/library/Service.php');
    }
    if (_PS_VERSION_ >= '1.5') {
        Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
        Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.2.9');
    } else {
        Configuration::updateValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
        Configuration::updateValue('LINEVEN_RLP_LAST_VERSION', '1.2.9');
    }
    return true;
}
