<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

function upgrade_module_1_5_0()
{
    // Database
    if (! file_exists(dirname(__FILE__).'/upgrade-1.5.0.sql')) {
        return (false);
    } else {
        if (! $sql = Tools::file_get_contents(dirname(__FILE__).'/upgrade-1.5.0.sql')) {
            return (false);
        }
    }
    $sql = str_replace('PREFIX_', _DB_PREFIX_, $sql);
    $sql = str_replace('MYSQL_ENGINE', _MYSQL_ENGINE_, $sql);
    $sql = preg_split('/;\s*[\r\n]+/', $sql);
    foreach ($sql as $query) {
        Db::getInstance()->Execute(trim($query));
    }

    // Update rules in tables
    $sql = 'SELECT * FROM `'._DB_PREFIX_.'lineven_rlp` ';
    $rlp_list = Db::getInstance()->ExecuteS($sql);
    for ($i = 0; $i < count($rlp_list); $i++) {
        $options = unserialize($rlp_list[$i]['options']);
        $is_keywords_rules_active = 0;
        $is_keywords_rules_reference = 0;
        $is_keywords_rules_name = 0;
        $is_keywords_rules_description = 0;
        if (isset($options['rules_keywords']) && $options['rules_keywords']['active']) {
            $is_keywords_rules_active = $options['rules_keywords'];
        }
        if (isset($options['rules_keywords']['name']) && $options['rules_keywords']['name'] == 1) {
            $is_keywords_rules_name = 1;
        }
        if (isset($options['rules_keywords']['description']) && $options['rules_keywords']['description'] == 1) {
            $is_keywords_rules_description = 1;
        }
        if (isset($options['rules_keywords']['reference']) && $options['rules_keywords']['reference'] == 1) {
            $is_keywords_rules_reference = 1;
        }
        Db::getInstance()->Execute(
            'UPDATE `'._DB_PREFIX_.'lineven_rlp`
                SET
                `options` = null,
                `is_keywords_rules_active` = '.(int)$is_keywords_rules_active.',
                `is_keywords_rules_reference` = '.(int)$is_keywords_rules_reference.',
                `is_keywords_rules_name` = '.(int)$is_keywords_rules_name.',
                `is_keywords_rules_description` = '.(int)$is_keywords_rules_description.'
                WHERE id = '.(int)$rlp_list[$i]['id']
        );
    }
    
    // Default keywords rules
    $keywords_rules = Db::getInstance()->ExecuteS(
        'SELECT * FROM `' . _DB_PREFIX_ . 'configuration`
        WHERE `name` = "LINEVEN_RLP_KW_RULES_DFLT"'
    );
    if (count($keywords_rules)) {
        foreach ($keywords_rules as $row) {
            if ($row['value'] != '') {
                $options = unserialize($row['value']);
                $new_options = array();
                if (isset($options['name']) && $options['name'] == 1) {
                    $new_options[] = 'name';
                }
                if (isset($options['description']) && $options['description'] == 1) {
                    $new_options[] = 'description';
                }
                if (isset($options['reference']) && $options['reference'] == 1) {
                    $new_options[] = 'reference';
                }
                Configuration::updateValue(
                    'LINEVEN_RLP_KW_RULES_DFLT',
                    serialize($new_options),
                    false,
                    $row['id_shop_group'],
                    $row['id_shop']
                );
            }
        }
    }
    
    // Configuration
    Configuration::updateGlobalValue('LINEVEN_RLP_IS_DEBUG_MODE', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_INST', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_INFOS', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_BO_LIST_FILTER', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_ORDER', serialize(array('category', 'accessories', 'associations')));
    Configuration::updateGlobalValue('LINEVEN_RLP_SAME_CATEGORY_DFLT', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_ACTIVE_ASSOC_KW', 1);
    if (Configuration::get('LINEVEN_RLP_OPP_DISPLAYING_MODE') == 'LIST') {
        Configuration::deleteByName('LINEVEN_RLP_OPP_DISPLAYING_MODE');
        Configuration::updateGlobalValue('LINEVEN_RLP_OPP_DISPLAYING_MODE', 'LIST_A');
    }
    if (Configuration::get('LINEVEN_RLP_OOP_DISPLAYING_MODE') == 'LIST') {
        Configuration::deleteByName('LINEVEN_RLP_OOP_DISPLAYING_MODE');
        Configuration::updateGlobalValue('LINEVEN_RLP_OOP_DISPLAYING_MODE', 'LIST_A');
    }
    // Specificities for PS 1.7
    if (version_compare('_PS_VERSION_', '1.7', '>=')) {
        Configuration::updateValue('LINEVEN_RLP_OPP_HOOK_USE', 'FOOTER');
        Configuration::updateValue('LINEVEN_RLP_OHP_IN_TAB', 0);
    }
    
    // Design list
    $design_list = Db::getInstance()->ExecuteS(
        'SELECT * FROM `' . _DB_PREFIX_ . 'configuration`
        WHERE `name` = "LINEVEN_RLP_DESIGN_LIST"'
    );
    if (count($design_list)) {
        foreach ($design_list as $row) {
            if ($row['value'] != '') {
                Configuration::updateValue(
                    'LINEVEN_RLP_DESIGN_LIST_A',
                    $row['value'],
                    false,
                    $row['id_shop_group'],
                    $row['id_shop']
                );
            }
        }
    }
    // Delete config
    Configuration::deleteByName('LINEVEN_RLP_BO_LIST_SORT_BY');
    Configuration::deleteByName('LINEVEN_RLP_BO_LIST_SORT_WAY');
    Configuration::deleteByName('LINEVEN_RLP_BO_LIST_FILTERS');
    Configuration::deleteByName('LINEVEN_RLP_DESIGN_LIST');
    
    // Delete old config
    Configuration::deleteByName('LINEVEN_RLP_HELP_TOOLTIP');
    Configuration::deleteByName('LINEVEN_RLP_SUPPORT_IS_DEBUG');
    Configuration::deleteByName('LINEVEN_RLP_SUPPORT_KEY');
    Configuration::deleteByName('LINEVEN_RLP_REGISTER');
    Configuration::deleteByName('LINEVEN_RLP_ACTIVE_LARGE_BDD');
    Configuration::deleteByName('LINEVEN_RLP_LARGE_BDD_REF');
    Configuration::deleteByName('LINEVEN_RLP_DOJO_VERSION');
    Configuration::deleteByName('LINEVEN_RLP_DOJO_BO_ACTIVE');
    Configuration::deleteByName('LINEVEN_RLP_DOJO_FO_ACTIVE');
    Configuration::deleteByName('LINEVEN_RLP_ACCESSORIES_PRIORITY');
    
    // Delete folders
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/backward_compatibility/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/backward_compatibility_rlp/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/content/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/css/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/js/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/img/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/library/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/css/vendor/font-awesome-4.3.0/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/fonts/vendor/font-awesome-4.3.0/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/include/');

    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/config/config_backoffice.inc.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Associations.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Default.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Design.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Hooks.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/QuickLinks.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Settings.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Support.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/Help.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/OnHomePage.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/OnOrderPage.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/admin/OnProductPage.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/Header.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/Home.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/Column.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/ProductFooter.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/ShoppingCart.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/front/redirection.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Support/Support.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/AssociationAccessoriesCombinations.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/AssociationAvailability.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/AssociationRules.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Design.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/forms/admin/Reviews.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/admin/Initialization.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/admin/Stores.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/module/Installation.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/module/QuickLinks.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/module/Support.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/services/Product.php');
    
    // For old versions
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/associations/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/default/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/design/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/hooks/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/settings/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/support/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/tab/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/onhomepage/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/onorderpage/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/onproductpage/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/footer.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/header.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/layout.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/messages.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/list.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/header/header_1_3.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home_1_3.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home_1_4.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home_1_5.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home_1_6.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/title.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/column/column_1_4.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/column/column_1_5.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/productfooter/productfooter_1_3.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/shoppingcart/shoppingcart_1_3.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/relatedproducts-list.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/relatedproducts-column-1-4.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/relatedproducts-column-1-5.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/relatedproducts-home-1-4.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/relatedproducts-home-1-5.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/AdminLinevenRelatedProducts.php');
    
    // Unactive module if templates change and not recompile templates in PS
    if (Configuration::get('PS_SMARTY_FORCE_COMPILE') == 0) {
        Module::disableByName('relatedproducts');
    }
    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_WARNING', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.5.0');
    return true;
}
