<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_1_6_0()
{
    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();
    
    // Hook register
    if (version_compare(_PS_VERSION_, '1.7', '<')) {
        $module->registerHook('displayAdminProductsExtra');
    } else {
        $module->registerHook('displayProductAdditionalInfo');
    }
    $module->registerHook('displayBackOfficeHeader');
    $module->registerHook('actionAdminControllerSetMedia');

    // Translations
    $title_translations = array();
    $default_title_translations = array('en' => 'Those products may also interest you', 'fr' => 'Ces produits sont susceptibles de vous intéresser');
    foreach (Language::getLanguages(false) as $language) {
        if (isset($default_title_translations[$language['iso_code']])) {
            $title_translations[(int)$language['id_lang']] = $default_title_translations[$language['iso_code']];
        } else {
            $title_translations[(int)$language['id_lang']] = $default_title_translations['en'];
        }
    }
    
    // Configuration
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_TITLE', $title_translations);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_MAX_PRODUCTS', 5);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_IMAGE_TYPE', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_DISPLAY_PRICE', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_DISPLAY_CART', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_THUMB_DP_TITLE', '0');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_THUMB_DP_DESC', '0');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_THUMB_DP_HEIGHT', 150);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_NEW_PRD', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_DP_REDUCTION', 0);
    
    // Delete old files
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/lineven.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/module.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/js/lineven.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/js/module.js');

    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.6.0');
    return true;
}
