<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_1_6_2()
{
    // Hook register
    if (version_compare(_PS_VERSION_, '1.7', '<')) {
        $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
        $module = new $module_class();
        $module->registerHook('displayRelatedProductsQuickView');
    }

    // New configuration
    Configuration::updateGlobalValue('LINEVEN_RLP_ACTIVE_BRAND', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_ACTIVE_BRAND_CAT', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OOP_SEPARATE_DISPLAY', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OPP_SEPARATE_DISPLAY', 0);
    
    // New translations
    $languages = Language::getLanguages(false);
    $default_titles_translations = array(
        'default' => array(
            'en' => 'Those products may also interest you',
            'fr' => 'Ces produits sont susceptibles de vous intéresser'
        ),
        'home' => array(
            'en' => 'So more',
            'fr' => 'Voir plus'
        ),
        'accessories' => array(
            'en' => 'Accessories',
            'fr' => 'Accessoires'
        ),
        'category' => array(
            'en' => 'In the same category',
            'fr' => 'Dans la même catégorie'
        ),
        'associations' => array(
            'en' => 'Those products may also interest you',
            'fr' => 'Ces produits sont susceptibles de vous intéresser'
        ),
        'brand' => array(
            'en' => 'From the same brand',
            'fr' => 'De la même marque'
        ),
        'brand_category' => array(
            'en' => 'From the same brand and category',
            'fr' => 'De la même marque'
        )
    );
    $title_translations = array();
    foreach ($default_titles_translations as $key => $translations) {
        foreach ($languages as $language) {
            if (isset($translations[$language['iso_code']])) {
                $title_translations[$key][(int)$language['id_lang']] = $translations[$language['iso_code']];
            } else {
                $title_translations[$key][(int)$language['id_lang']] = $translations['en'];
            }
        }
    }
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_ACC_TITLE', $title_translations['accessories']);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_CAT_TITLE', $title_translations['category']);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_ASS_TITLE', $title_translations['associations']);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_BRD_TITLE', $title_translations['brand']);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_BRDCAT_TITLE', $title_translations['brand_category']);
    Configuration::updateGlobalValue('LINEVEN_RLP_DISPLAY_VIEWED', false);

    Configuration::updateGlobalValue('LINEVEN_RLP_HOOK_AJAXCART', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_TITLE', $title_translations['default']);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_MAX_PRODUCTS', 5);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_IMAGE_TYPE', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_DISPLAY_PRICE', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_DISPLAY_CART', '1');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_THUMB_DP_TITLE', '0');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_THUMB_DP_DESC', '0');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_THUMB_DP_HEIGHT', 150);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_NEW_PRD', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_DP_REDUCTION', 0);

    // Delete old files
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/config/smarty.inc.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/lineven.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/css/module.css');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/js/lineven.js');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/js/module.js');

    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '1.6.2');
    return true;
}
