<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_2_0_0()
{
    // Load module
    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();
    $module->registerHook('displayProductExtraContent');
    $module->registerHook('displayRelatedProductsAjaxCart');

    // Install new tables
    require_once(_LINEVEN_MODULE_RLP_REQUIRE_DIR_.'/src/Core/DbTools.php');
    $db_tools = new LinevenRlpDbTools();
    $db_tools->setInstallFiles(true);
    $db_tools->installTables();

    // Plugins install
    require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/install/plugins.inc.php');

    // Configuration to upgrade
    update_configuration_2_0_0();
    Configuration::updateGlobalValue('LINEVEN_RLP_OHP_DISPLAYING_MODE', 'THEME');
    Configuration::updateGlobalValue('LINEVEN_RLP_OCL_DISPLAYING_MODE', 'CLASSIC');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_DISPLAYING_MODE', 'THUMBNAILS');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_DISPLAYING_MODE', 'THUMBNAILS');
    LinevenRlpPluginObject::reorder();

    // Delete old configuration
    Configuration::deleteByName('LINEVEN_RLP_ACCESS_TO_LIST');
    Configuration::deleteByName('LINEVEN_RLP_ACTIVE_ACCESSORIES');
    Configuration::deleteByName('LINEVEN_RLP_SAME_CATEGORY');
    Configuration::deleteByName('LINEVEN_RLP_SAME_CATEGORY_DFLT');
    Configuration::deleteByName('LINEVEN_RLP_ACTIVE_BRAND');
    Configuration::deleteByName('LINEVEN_RLP_ACTIVE_BRAND_CAT');
    Configuration::deleteByName('LINEVEN_RLP_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_ORDER');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_ACC_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_CAT_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_ASS_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_BRD_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_BRDCAT_TITLE');
    Configuration::deleteByName('LINEVEN_RLP_DISPLAY_VIEWED');

    // Delete old files
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/hook/admin/ProductsExtra.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/controllers/hook/ProductFooter.php');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/forms/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/models/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/services/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/src/Core/Presenter/PresenterGlobalVariables.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/src/Core/Presenter/PrestashopVariablesPresenter_1.6.php');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/src/Core/Presenter/PrestashopVariablesPresenter_1.7.php');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/src/Module/Association/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/src/Module/Partners/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/module/support/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/module/_partials/messages.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/module/_partials/notifications/for_popovers_demonstration.tpl');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/admin/catalog/1.6/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/admin/catalog/1.7/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/column/column.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/home_content.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/home/tab.tpl');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/productfooter/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/quickview/view.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/shoppingcart/ajax_cart.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/shoppingcart/shopping_cart.tpl');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/column/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/js_variables.tpl');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/list_a/');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/list_b/');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/products.tpl');
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/theme.tpl');
    LinevenRlpTools::rrmdir(_PS_MODULE_DIR_.'/relatedproducts/views/templates/hook/_partials/thumbnails/');

    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PREVIOUS_VERSION', Configuration::get('LINEVEN_RLP_LAST_VERSION'));
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '2.0.0');
    return true;
}

/**
 * Update configuration.
 */
function update_configuration_2_0_0()
{
    $pages_defs = array(
        'OHP' => array(
            'image_type' => false,
        ),
        'OCL' => array(
            'image_type' => true,
        ),
        'OPP' => array(
            'image_type' => true,
        ),
        'OQV' => array(
            'image_type' => true,
        ),
        'OOP' => array(
            'image_type' => true,
        ),
        'OAC' => array(
            'image_type' => true,
        ),
    );
    $plugins_to_active = array();

    foreach ($pages_defs as $configuration_code => $defs) {
        // Images types
        if ($defs['image_type']) {
            $images_types_page = Db::getInstance()->ExecuteS(
                'SELECT * FROM `' . _DB_PREFIX_ . 'configuration`
            WHERE `name` = "LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE"'
            );
            if (count($images_types_page)) {
                $products_image = ImageType::getImagesTypes();
                foreach ($images_types_page as $row) {
                    $image_type_name = ImageType::getFormattedName('small');
                    $image_type_width = 20;
                    $image_type_height = 20;
                    foreach ($products_image as $type) {
                        if ($type['id_image_type'] == (int)$row['value']) {
                            $image_type_name = $type['name'];
                            $image_type_width = $type['width'];
                            $image_type_height = $type['height'];
                            break;
                        }
                    }
                    if ($row['value'] != '') {
                        Configuration::updateValue(
                            'LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE_NAME',
                            $image_type_name,
                            false,
                            $row['id_shop_group'],
                            $row['id_shop']
                        );
                        Configuration::updateValue(
                            'LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE_WIDTH',
                            $image_type_width,
                            false,
                            $row['id_shop_group'],
                            $row['id_shop']
                        );
                        Configuration::updateValue(
                            'LINEVEN_RLP_'.$configuration_code.'_IMAGE_TYPE_HEIGHT',
                            $image_type_height,
                            false,
                            $row['id_shop_group'],
                            $row['id_shop']
                        );
                    }
                }
            }
        }

        // Randomize
        $randomizes = Db::getInstance()->ExecuteS(
            'SELECT * FROM `' . _DB_PREFIX_ . 'configuration`
            WHERE `name` = "LINEVEN_RLP_RAMDOMIZE"'
        );
        if (count($randomizes)) {
            foreach ($randomizes as $row) {
                if ($row['value'] != '') {
                    Configuration::updateValue(
                        'LINEVEN_RLP_'.$configuration_code.'_RAMDOMIZE',
                        (int)$row['value'],
                        false,
                        $row['id_shop_group'],
                        $row['id_shop']
                    );
                }
            }
        }

        // Plugins
        $plugins = Db::getInstance()->ExecuteS(
            'SELECT * FROM `' . _DB_PREFIX_ . 'configuration`
            WHERE `name` = "LINEVEN_RLP_DISPLAY_ORDER"'
        );
        if (count($plugins)) {
            foreach ($plugins as $row) {
                if ($row['value'] != '') {
                    $current_plugins = unserialize($row['value']);
                    $new_plugins = array();
                    foreach ($current_plugins as $plugin) {
                        $plugin = Tools::strtoupper($plugin);
                        if ($plugin != 'NONE') {
                            $use_plugin = false;
                            if ($plugin == 'CATEGORY') {
                                $plugin = 'SAME_CATEGORY';
                            }
                            if (($plugin == 'ACCESSORIES' && Configuration::get('LINEVEN_RLP_ACTIVE_ACCESSORIES', null, $row['id_shop_group'], $row['id_shop'])) ||
                                ($plugin == 'SAME_CATEGORY' && Configuration::get('LINEVEN_RLP_SAME_CATEGORY', null, $row['id_shop_group'], $row['id_shop'])) ||
                                ($plugin == 'BRAND' && Configuration::get('LINEVEN_RLP_ACTIVE_BRAND', null, $row['id_shop_group'], $row['id_shop'])) ||
                                ($plugin == 'BRAND_CATEGORY' && Configuration::get('LINEVEN_RLP_ACTIVE_BRAND_CAT', null, $row['id_shop_group'], $row['id_shop'])) ||
                                ($plugin == 'ASSOCIATIONS')
                            ) {
                                $use_plugin = true;
                            }
                            if ($use_plugin) {
                                $new_plugins[$plugin]  = Configuration::get(
                                    'LINEVEN_RLP_'.$configuration_code.'_MAX_PRODUCTS',
                                    null,
                                    $row['id_shop_group'],
                                    $row['id_shop']
                                );
                                if (!in_array($plugin, $plugins_to_active)) {
                                    $plugins_to_active[] = $plugin;
                                }
                            }
                        }
                    }
                    if (Configuration::get('LINEVEN_RLP_DISPLAY_VIEWED', null, $row['id_shop_group'], $row['id_shop'])) {
                        $plugin = 'ALREADY_SEEN';
                        $plugins_to_active[] = $plugin;
                        $new_plugins[$plugin]  = Configuration::get(
                            'LINEVEN_RLP_'.$configuration_code.'_MAX_PRODUCTS',
                            null,
                            $row['id_shop_group'],
                            $row['id_shop']
                        );
                    }
                    Configuration::updateValue(
                        'LINEVEN_RLP_'.$configuration_code.'_PLUGINS',
                        serialize($new_plugins),
                        false,
                        $row['id_shop_group'],
                        $row['id_shop']
                    );
                }
            }
        }
    }
    Db::getInstance()->Execute(
        'UPDATE `'._DB_PREFIX_.'lineven_rlp_plugins`
            SET `order_display` = 99, `is_active` = 0'
    );
    if (count($plugins_to_active)) {
        $order = 1;
        foreach ($plugins_to_active as $plugin) {
            Db::getInstance()->Execute(
                'UPDATE `'._DB_PREFIX_.'lineven_rlp_plugins`
                SET `order_display` = '.$order.', `is_active` = 1
                WHERE code = "'.pSQL($plugin).'"'
            );
            $order++;
        }
    }
}
