<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_2_2_0()
{
    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();
    $module->init();

    // Install new plugin
    require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/install/plugins.inc.php');

    // Database
    if (! file_exists(dirname(__FILE__).'/upgrade-2.2.0.sql')) {
        return (false);
    } else {
        if (! $sql = Tools::file_get_contents(dirname(__FILE__).'/upgrade-2.2.0.sql')) {
            return (false);
        }
    }
    $sql = str_replace('PREFIX_', _DB_PREFIX_, $sql);
    $sql = str_replace('MYSQL_ENGINE', _MYSQL_ENGINE_, $sql);
    $sql = preg_split('/;\s*[\r\n]+/', $sql);
    foreach ($sql as $query) {
        Db::getInstance()->Execute(trim($query));
    }

    // Old files
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/module/_partials/diagnostic/results_repair.tpl');

    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PREVIOUS_VERSION', Configuration::get('LINEVEN_RLP_LAST_VERSION'));
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '2.2.0');
    return true;
}
