<?php
/**
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 */

require_once(dirname(__FILE__).'/../../../config/config.inc.php');
require_once(dirname(__FILE__).'/../config/config.inc.php');
require_once(dirname(__FILE__).'/../../../init.php');
require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/'._LINEVEN_MODULE_RLP_FILENAME_.'.php');

function upgrade_module_3_0_0()
{
    $module_class = _LINEVEN_MODULE_RLP_CLASSNAME_;
    $module = new $module_class();
    $module->init();

    // Install hook
    $module->registerHook('displayRelatedProductsQuickView');

    // Install new plugin
    require_once(_PS_MODULE_DIR_.'/'._LINEVEN_MODULE_RLP_DIRNAME_.'/install/plugins.inc.php');

    // Old files
    LinevenRlpTools::deleteFile(_PS_MODULE_DIR_.'/relatedproducts/views/templates/admin/module/hooks/_delete_section_button.tpl');

    // New configuration
    Configuration::updateGlobalValue('LINEVEN_RLP_OPP_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OPP_RANDOM_SEARCH', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_RANDOM_SEARCH', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OHP_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OHP_RANDOM_SEARCH', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OCL_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OCL_RANDOM_SEARCH', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OOP_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OOP_RANDOM_SEARCH', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_SORT_DISPLAY_WAY', 'asc');
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_RANDOM_SEARCH', 0);

    Configuration::updateGlobalValue('LINEVEN_RLP_OOP_HOOK_USE', 'FOOTER');
    Configuration::updateGlobalValue('LINEVEN_RLP_SPECIFIC_HOOK_DEF', serialize(array()));

    Configuration::updateGlobalValue('LINEVEN_RLP_OPP_IS_ASYNC', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OOP_IS_ASYNC', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OQV_IS_ASYNC', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OHP_IS_ASYNC', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OCL_IS_ASYNC', 0);
    Configuration::updateGlobalValue('LINEVEN_RLP_OAC_IS_ASYNC', 0);

    // Update specific configuration
    update_configuration_3_0_0();

    // Delete configuration
    Configuration::deleteByName('LINEVEN_RLP_OPP_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_OQV_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_OHP_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_OCL_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_OOP_RAMDOMIZE');
    Configuration::deleteByName('LINEVEN_RLP_OAC_RAMDOMIZE');

    // Update version
    Configuration::updateGlobalValue('LINEVEN_RLP_NOTIFICATION_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PANEL_UPD', 1);
    Configuration::updateGlobalValue('LINEVEN_RLP_PREVIOUS_VERSION', Configuration::get('LINEVEN_RLP_LAST_VERSION'));
    Configuration::updateGlobalValue('LINEVEN_RLP_LAST_VERSION', '3.0.0');
    return true;
}


/**
 * Update configuration.
 */
function update_configuration_3_0_0()
{
    $pages_defs = array('OHP', 'OCL', 'OPP', 'OQV', 'OOP', 'OAC');

    foreach ($pages_defs as $configuration_code) {
        // Randomize
        $random_value = Db::getInstance()->ExecuteS(
            'SELECT * FROM `'._DB_PREFIX_.'configuration`
            WHERE `name` = "LINEVEN_RLP_'.$configuration_code.'_RAMDOMIZE"'
        );
        if (count($random_value)) {
            foreach ($random_value as $row) {
                Configuration::updateValue(
                    'LINEVEN_RLP_'.$configuration_code.'_RANDOM_PLUGINS',
                    (int)$row['value'],
                    false,
                    $row['id_shop_group'],
                    $row['id_shop']
                );
                if ((int)$row['value'] == 1) {
                    Configuration::updateGlobalValue('LINEVEN_RLP_'.$configuration_code.'_SORT_DISPLAY', 'RANDOM');
                } else {
                    Configuration::updateGlobalValue('LINEVEN_RLP_'.$configuration_code.'_SORT_DISPLAY', 'DEFAULT');
                }
            }
        }
        // Plugins
        $plugins_value = Db::getInstance()->ExecuteS(
            'SELECT * FROM `'._DB_PREFIX_.'configuration`
            WHERE `name` = "LINEVEN_RLP_'.$configuration_code.'_PLUGINS"'
        );
        if (count($plugins_value)) {
            foreach ($plugins_value as $row) {
                $plugins_value_formated = array();
                if ($row['value'] != null) {
                    $plugins_used = unserialize($row['value']);
                    foreach ($plugins_used as $plugin_code => $plugin_value) {
                        $plugins_value_formated[$plugin_code] = array(
                            'max_products' => (int)$plugin_value,
                            'options' => array()
                        );
                    }
                }
                Configuration::updateValue(
                    'LINEVEN_RLP_'.$configuration_code.'_PLUGINS',
                    serialize($plugins_value_formated),
                    false,
                    $row['id_shop_group'],
                    $row['id_shop']
                );
            }
        }
    }
}
