{*
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author Lineven
 * @copyright 2020 Lineven
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}
 
{extends file="./../../_configure/helpers/form/form.tpl"}

{block name="defaultForm"}
	<div class="panel">
		<div class="panel-heading">
			<i class="fa fa-edit"></i>
			{if $association->id != null && $association->id != 0}
				{l s='Edit association' mod='relatedproducts'}
				<span class="badge">{l s='N' mod='relatedproducts'}&deg;{$association->id|intval}</span> 
			{else}
				{l s='Create an association' mod='relatedproducts'}
			{/if}
			<div class="panel-heading-action">
				<a class="list-toolbar-btn" href="{$cancel_url|escape:'html':'UTF-8'}">
					<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Cancel' mod='relatedproducts'}" data-html="true">
						<i class="process-icon-cancel "></i>
					</span>
				</a>
			</div>
		</div>
		{$smarty.block.parent}
		<div class="panel-footer">
			<button type="button" value="1" id="association_addedit_cancel" class="btn btn-default pull-left" name="linevenCancelAssociation" onClick="LinevenRlpModule.Associations.Edit.doOnClickAssociationCancel()">
				<i class="process-icon-cancel"></i> {l s='Cancel' mod='relatedproducts'}
			</button>
			<button type="button" value="1" id="association_addedit_save" class="btn btn-default pull-right" name="linevenSubmitAssociation" onClick="LinevenRlpModule.Associations.Edit.doOnClickAssociationSave({$association->id|intval}, false)">
				<i class="process-icon-save"></i> {l s='Save' mod='relatedproducts'}
			</button>
			<button type="button" value="1" id="association_addedit_save_stay" class="btn btn-default pull-right" name="linevenSubmitSaveStayAssociation" onClick="LinevenRlpModule.Associations.Edit.doOnClickAssociationSave({$association->id|intval}, true)">
				<i class="process-icon-save"></i> {l s='Save and stay' mod='relatedproducts'}
			</button>
		</div>
	</div>
	<script>
		LinevenRlpModule.Associations.Edit.prepareContent();
		{literal}
			$(".chosen").chosen({width: "280px"});
		{/literal}
	</script>
{/block}

{block name="fieldset"}
	{if $f == 'association_type'}
		<div class="panel">
			<ul class="nav nav-tabs">
				<li id="tab-1" class="active">
   				<a href="#relatedproducts-associations-association_type" data-toggle="tab">{l s='Association' mod='relatedproducts'}</a>
				</li>
				<li id="tab-2">
   				<a href="#relatedproducts-associations-specifics_rules" data-toggle="tab">{l s='Specifics rules' mod='relatedproducts'}</a>
				</li>
	    		<li id="tab-3">
					<a href="#relatedproducts-associations-extras" data-toggle="tab">{l s='Extras' mod='relatedproducts'}</a>
				</li>
			</ul>
			<div class="lineven-tabs-content tab-content">
				<!-- Activation settings -->
				<div id="relatedproducts-associations-association_type" class="tab-pane active">
	{/if}
	{if $f == 'association_type' || $f == 'selection_rule_category' || $f == 'selection_rule_keywords' || $f == 'display_category' || $f == 'display_keywords' || $f == 'which_hooks' || $f == 'reciprocity'}
		{$smarty.block.parent}
		{if $f == 'selection_rule_category'}
			{include file="./addedit/product_selection_settings.tpl"}		
		{/if}		
		{if $f == 'display_category'}
			{include file="./addedit/product_displayed_settings.tpl"}		
		{/if}		
	{/if}
	{if $f == 'reciprocity'}
		</div>
	{/if}

	{if $f == 'specifics_rules'}
	   <!-- For post settings --> 
		<div id="relatedproducts-associations-specifics_rules" class="tab-pane">
			{$smarty.block.parent}
		</div>
	{/if}
	{if $f == 'description' || $f == 'comments'}
	   <!-- For post settings --> 
		<div id="relatedproducts-associations-extras" class="tab-pane">
			{$smarty.block.parent}
	{/if}
	{if $f == 'comments'}
			</div>
		</div>
	{/if}
{/block}
