{*
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author Lineven
 * @copyright 2020 Lineven
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}

{if isset($product_displayed) && $product_displayed}
{assign var=imageCoverId value=Product::getCover($product_displayed.id_product)}
<tr id="display_product-{$product_displayed.id_product|escape:'html':'UTF-8'}" data-display-product-id="{$product_displayed.id_product|escape:'html':'UTF-8'}">
    <td class="center">
        {* HTML CONTENT to display image product *}
        {LinevenRlpProductPresenter::getThumbnailImage($product_displayed.id_product, $imageCoverId.id_image) nofilter}
        {* /HTML CONTENT *}
    </td>
    <td class="left">
        <a href="{$link->getAdminLink('AdminProducts')|escape:'html':'UTF-8'}&updateproduct&id_product={$product_displayed.id_product|intval}" target="_blank" title="{l s='Edit product' mod='relatedproducts'}"><strong>{$product_displayed.name|escape:'html':'UTF-8'}</strong></a><br />
        <em>{l s='Ref:' mod='relatedproducts'} {$product_displayed.reference|escape:'html':'UTF-8'}</em>
    </td>
    <td class="left">
        {$product_displayed.description_short|strip_tags|escape:'html':'UTF-8'|truncate:80:'...'}
    </td>
    <td class="center">
        <button data-display-product-id="{$product_displayed.id_product|escape:'html':'UTF-8'}" id="remove_product" onClick="LinevenRlpModule.Associations.Edit.removeDisplayProduct({$product_displayed.id_product|intval})" class="btn btn-default" type="button"><i class="icon-trash"></i></button>
    </td>
</tr>
{/if}