{*
 * Library for Lineven Prestashop Modules (Version 4.1.2)
 *
 * @author    Lineven
 * @copyright 2020 Lineven
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}

{extends file='../_partials/dashboard/index.tpl'}

{block name="infos_content"}
    <p>
        <img src="{$lineven.rlp.urls.base_url|escape:'html':'UTF-8'}/logo.png" class="pull-left" style="margin-right:10px;" id="{$lineven.rlp.name|escape:'html':'UTF-8'}-logo" />
        {l s='This module allow you to increase your sales by incentives purchases (cross selling) using plugins and customized associations (products, categories, keywords, ...) based on the products consulted, the customer cart and orders.' mod='relatedproducts'}
        <br/>
        {l s='You will be able to create all associations as you want.' mod='relatedproducts'}
    </p>
{/block}
{block name="report_icon"}fa fa-tachometer{/block}
{block name="report_title"}
    {l s='Associations report' mod='relatedproducts'}
    <div class="panel-heading-action">
        <a class="list-toolbar-btn" href="{LinevenRlpTools::getBackofficeURI('Associations', 'list', 'associations:associations')|escape:'html':'UTF-8'}">
            <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Associations list' mod='relatedproducts'}" data-html="true" data-placement="top">
                <i class="icon-fa-panel-heading fa fa-chain"></i>
            </span>
        </a>
        <a class="list-toolbar-btn" href="{LinevenRlpTools::getBackofficeURI('Associations', 'addEdit', 'associations:associations:add')|escape:'html':'UTF-8'}">
            <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Create an association' mod='relatedproducts'}" data-html="true" data-placement="top">
                <i class="process-icon-new"></i>
            </span>
        </a>
    </div>
{/block}
{block name="report_content"}
    {if $lineven.rlp.admin.datas.associations_report.rules_cart || $lineven.rlp.admin.datas.associations_report.rules_order || $lineven.rlp.admin.datas.associations_report.rules_viewed}
        <div>
            <span>
                {l s='You currently use' mod='relatedproducts'}&nbsp;&bull;
                {if $lineven.rlp.admin.datas.associations_report.rules_cart}
                    <strong>{l s='customer cart' mod='relatedproducts'}</strong>&nbsp;&bull;&nbsp;
                {/if}
                {if $lineven.rlp.admin.datas.associations_report.rules_order}
                    <strong>{l s='customer orders' mod='relatedproducts'}</strong>&nbsp;&bull;&nbsp;
                {/if}
                {if $lineven.rlp.admin.datas.associations_report.rules_viewed}
                    <strong>{l s='viewed products' mod='relatedproducts'}</strong>&nbsp;&bull;&nbsp;
                {/if}
            </span>
        </div>
    {else}
        <div class="report_no_selection_rules">
            {l s='Be careful, you have not choose selection rules to use.' mod='relatedproducts'}
        </div>
    {/if}
    <br/>
    {if count($lineven.rlp.admin.datas.associations_report.plugins)}
        <div>
            <span>{l s='Plugins used are' mod='relatedproducts'}&nbsp;&bull;
                {foreach from=$lineven.rlp.admin.datas.associations_report.plugins item=plugin name=plugin}
                    <strong>{LinevenRlpPluginObject::getStaticDisplayedName($plugin->name)|escape:'html':'UTF-8'}</strong>&nbsp;&bull;&nbsp;
                {/foreach}
            </span>
        </div>
    {else}
        <div class="report_no_plugin">
            {l s='Be careful, you have not used plugins.' mod='relatedproducts'}
        </div>
    {/if}
    {if $lineven.rlp.admin.datas.report_addons_reviews_associated}
        <br/>
        <div>{l s='The module is associated to "Go Reviews - Reviews, Advices, Ratings, SEO and Google Rich Snippets" addons.' mod='relatedproducts'}</div>
    {/if}
{/block}