{*
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author Lineven
 * @copyright 2020 Lineven
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}

{if $displayed_products != null && count($displayed_products)}
	{foreach from=$displayed_products item='product' name='product'}
		{assign var=imageCoverId value=Product::getCover($product.product_id)}
		<tr id="association-{$product.id|intval}" data-association-id="{$product.id|intval}" data-display-product-id="{$product.product_id|intval}">
			<td class="text-left">
				{$product.product_id|intval}
			</td>
			<td class="text-center">
                {* HTML CONTENT to display product image *}
				{LinevenRlpProductPresenter::getThumbnailImage($product.product_id, $imageCoverId.id_image) nofilter}
                {* /HTML CONTENT *}
			</td>
			<td class="text-left">
				<a href="{$link->getAdminLink('AdminProducts')|escape:'html':'UTF-8'}&updateproduct&id_product={$product.product_id|intval}" target="_blank" title="{l s='Edit product' mod='relatedproducts'}"><strong>{$product.displayed_product_name|escape:'html':'UTF-8'}</strong></a><br />
				<em>{l s='Ref:' mod='relatedproducts'} {$product.displayed_product_reference|escape:'html':'UTF-8'}</em>
			</td>
			<td class="text-center">
				<button data-association-id="{$product.id|intval}" data-display-product-id="{$product.product_id|intval}"
					id="remove_product"
					onClick="LinevenRlpModule.Catalog.removeDisplayProduct({$product.id|intval})"
					class="btn btn-invisible" type="button"><i class="material-icons">delete</i></button>
			</td>
		</tr>
	{/foreach}
{else}
	<tr>
		<td colspan="3" class="text-left">
            {l s='No displayed products.' mod='relatedproducts'}
		</td>
	</tr>
{/if}