{**
 * Copyright © Lyra Network.
 * This file is part of Systempay plugin for PrestaShop. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra-network.com/)
 * @copyright Lyra Network
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *}

<br /><br />
<div style="padding-left: 40px;" id="systempay_oneclick_payment_description">
  <ul id="systempay_oneclick_payment_description_1">
    <li>
      <span class="systempay_span">{l s='You will pay with your registered means of payment' mod='systempay'}<b> {$systempay_saved_payment_mean|escape:'html':'UTF-8'}. </b>{l s='No data entry is needed.' mod='systempay'}</span>
    </li>

    <li style="margin: 8px 0px 8px;">
      <span class="systempay_span">{l s='OR' mod='systempay'}</span>
    </li>

    <li>
      <p class="systempay_link" onclick="systempayOneclickPaymentSelect(0)">{l s='Click here to pay with another means of payment.' mod='systempay'}</p>
    </li>
  </ul>
{if ($systempay_std_card_data_mode == '2')}
  <script type="text/javascript">
    function systempayOneclickPaymentSelect(paymentByIdentifier) {
      if (paymentByIdentifier) {
        $("#systempay_oneclick_payment_description").show();
        $("#systempay_standard").hide();
        $("#systempay_payment_by_identifier").val("1");
      } else {
        $("#systempay_oneclick_payment_description").hide();
        $("#systempay_standard").show();
        $("#systempay_payment_by_identifier").val("0");
      }
    }
  </script>
{else}
  <ul id="systempay_oneclick_payment_description_2" style="display: none;">
    {if ($systempay_std_card_data_mode != '5') || $systempay_rest_popin}
      <li>{l s='You will enter payment data after order confirmation.' mod='systempay'}</li>
    {/if}

      <li style="margin: 8px 0px 8px;">
        <span class="systempay_span">{l s='OR' mod='systempay'}</span>
      </li>
      <li>
        <p class="systempay_link" onclick="systempayOneclickPaymentSelect(1)">{l s='Click here to pay with your registered means of payment.' mod='systempay'}</p>
      </li>
  </ul>

  <script type="text/javascript">
    function systempayOneclickPaymentSelect(paymentByIdentifier) {
      if (paymentByIdentifier) {
        $("#systempay_oneclick_payment_description_1").show();
        $("#systempay_oneclick_payment_description_2").hide()
        $("#systempay_payment_by_identifier").val("1");
      } else {
        $("#systempay_oneclick_payment_description_1").hide();
        $("#systempay_oneclick_payment_description_2").show();
        $("#systempay_payment_by_identifier").val("0");
      }

      {if ($systempay_std_card_data_mode == '5')}
        systempayUpdateRestToken();
        setTimeout(function () {
          systempayInitRestEvents();
        }, 200);
      {/if}
    }

    function systempayUpdateRestToken() {
      KR.removeForms();

      if ($("#systempay_payment_by_identifier").val() == '1') {
        var token = "{$systempay_rest_identifier_token|escape:'html':'UTF-8'}";
      } else {
        var token = "{$systempay_rest_form_token|escape:'html':'UTF-8'}";
      }

      var isPopin = document.getElementsByClassName('kr-popin-button');
      if (isPopin.length !== 0) {
        var button =  '<button type="button" id="systempay_hidden_button" class="kr-payment-button"></button>';
      } else {
        var button = '<div style="display: none;">'
                   + '   <button type="button" id="systempay_hidden_button" class="kr-payment-button"></button>'
                   + '</div>';
      }

      $("#systempay_standard_rest_wrapper").html(
          ' <div class="systempay kr-embedded" {if $systempay_rest_popin} kr-popin{/if} kr-form-token="' + token + '" >'
          + '  <div class="kr-pan"></div>'
          + '  <div class="kr-expiry"></div>'
          + '  <div class="kr-security-code"></div>'

          + button

          + '  <div class="kr-field processing" style="display: none; border: none !important;">'
          + '      <div style="background-image: url({$smarty.const._MODULE_DIR_|escape:'html':'UTF-8'}systempay/views/img/loading_big.gif);'
          + '                  margin: 0 auto; display: block; height: 35px; background-position: center;'
          + '                  background-repeat: no-repeat; background-size: 35px;">'
          + '      </div>'
          + '   </div>'
          + '   <div class="kr-form-error"></div>'
          + '</div>');
    }
    </script>
{/if}

{if version_compare($smarty.const._PS_VERSION_, '1.6', '<')}
  <input id="systempay_standard_link" value="{l s='Pay' mod='systempay'}" class="button" />
{else}
  <button id="systempay_standard_link" class="button btn btn-default standard-checkout button-medium" >
    <span>{l s='Pay' mod='systempay'}</span>
  </button>
{/if}

</div>