<?php

class Product extends ProductCore
{
    public static function getCombinations($id_product, $id_lang = null)
    {
        $id_lang = $id_lang ?? Context::getContext()->language->id;

        $product                = new Product($id_product);
        $combinations           = [];
        $combination_images     = $product->getCombinationImages($id_lang);
        $attributes_groups      = $product->getAttributesGroups($id_lang);
        $combination_prices_set = [];

        foreach ($attributes_groups as $k => $row) {

            if (!isset($combinations[$row['id_product_attribute']]['attributes'][$row['id_attribute_group']])) {
                $combinations[$row['id_product_attribute']]['attributes'][$row['id_attribute_group']] = [
                  'value'             => $row['attribute_name'],
                  'id_attribute'      => (int)$row['id_attribute'],
                  'group_name'        => $row['group_name'],
                  'public_group_name' => $row['public_group_name']
                ];
            }

            //$combinations[$row['id_product_attribute']]['attributes_values'][$row['id_attribute_group']] = $row['attribute_name'];
            //$combinations[$row['id_product_attribute']]['attributes'][$row['id_attribute_group']]        = (int)$row['id_attribute'];
            $combinations[$row['id_product_attribute']]['price'] = (float)$row['price'];

            if (!isset($combination_prices_set[(int)$row['id_product_attribute']])) {
                $combination_specific_price = null;
                Product::getPriceStatic((int)$product->id, false, $row['id_product_attribute'], 6, null, false,
                  true, 1, false, null, null, null, $combination_specific_price);
                $combination_prices_set[(int)$row['id_product_attribute']]    = true;
                $combinations[$row['id_product_attribute']]['specific_price'] = $combination_specific_price;
            }

            $combinations[$row['id_product_attribute']]['ecotax']           = (float)$row['ecotax'];
            $combinations[$row['id_product_attribute']]['weight']           = (float)$row['weight'];
            $combinations[$row['id_product_attribute']]['quantity']         = (int)$row['quantity'];
            $combinations[$row['id_product_attribute']]['reference']        = $row['reference'];
            $combinations[$row['id_product_attribute']]['unit_impact']      = $row['unit_price_impact'];
            $combinations[$row['id_product_attribute']]['minimal_quantity'] = $row['minimal_quantity'];
            if ($row['available_date'] != '0000-00-00' && Validate::isDate($row['available_date'])) {
                $combinations[$row['id_product_attribute']]['available_date'] = $row['available_date'];
                $combinations[$row['id_product_attribute']]['date_formatted'] = Tools::displayDate($row['available_date']);
            } else {
                $combinations[$row['id_product_attribute']]['available_date'] = $combinations[$row['id_product_attribute']]['date_formatted'] = '';
            }

            if (!isset($combination_images[$row['id_product_attribute']][0]['id_image'])) {
                $combinations[$row['id_product_attribute']]['id_image'] = -1;
            } else {
                $combinations[$row['id_product_attribute']]['id_image'] = $id_image = (int)$combination_images[$row['id_product_attribute']][0]['id_image'];
            }
        }

        return $combinations;
    }
}
