import _ from 'underscore'

let header = document.querySelector('#header')

let setScrolledClass = () => {
  let scrollPosition = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0
  if (scrollPosition > 0) {
    if (!header.classList.contains('scrolled')) {
      header.classList.add('scrolled')
      document.body.classList.add('scrolled')
    }
  } else {
    if (header.classList.contains('scrolled')) {
      header.classList.remove('scrolled')
      document.body.classList.remove('scrolled')
    }
  }
}

window.onscroll = _.throttle(e => {
  setScrolledClass()
}, 100)

window.onresize = _.throttle(e => {
  setScrolledClass()
}, 200)
