import _ from 'underscore'
import $ from 'jquery'
import noUiSlider from 'nouislider'
import wNumb from 'wnumb'

const getParameterByName = function (name, url) {
  if (!url) {
    url = window.location.href
  }
  name = name.replace(/[[\]]/g, '\\$&')
  const regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)')
  const results = regex.exec(url)

  if (!results) return null
  if (!results[2]) return ''
  return decodeURIComponent(results[2].replace(/\+/g, ' '))
}

// Génère la nouvelle URL avec tri à facette et ordre
const setNewUrl = function (type, newElements, toReplace) {
  let order = getParameterByName('order')
  if (_.isNull(order)) {
    order = ''
  }

  let query = getParameterByName('q')
  if (_.isNull(query)) {
    query = ''
  }

  if (type === 'q') {
    if (!_.isNull(query)) {
      query = query.split('/')
    } else {
      query = []
    }
    _.each(query, function (element, index) {
      if (toReplace !== '' && !_.isUndefined(element)) {
        let isIn = element.indexOf(toReplace)
        if (isIn > -1) {
          query[index] = ''
        }
      }
    })
    query.push(newElements)
    query = query.join('/')
  } else if (type === 'order') {
    order = newElements
  }

  const finalUrl = '?q=' + query + '&order=' + order
  window.prestashop.emit('updateFacets', finalUrl)
}

// Génère le slider des prix
const makeSliderPrix = function () {
  const sliderPrix = document.querySelector('.slider.slider-price')
  const $sliderPrix = $(sliderPrix)

  if ($sliderPrix.length) {
    const values = $sliderPrix.data('values')

    let min = parseInt(values['min'])
    let max = parseInt(values['max'])

    if (min >= max) {
      min = max - 1
    }

    noUiSlider.create(sliderPrix, {
      start: [min, max],
      step: 1,
      behaviour: 'none',
      connect: true,
      tooltips: true,
      range: {
        'min': min,
        'max': max
      },
      format: wNumb({
        decimals: 0,
        mark: '',
        thousand: '',
        prefix: '',
        postfix: '&nbsp;€'
      })
    })

    sliderPrix.noUiSlider.on('set', function () {
      let valueMin = parseInt(this.get()[0])
      let valueMax = parseInt(this.get()[1])

      const selected = ['Prix-€', valueMin, valueMax]
      const urlPrix = encodeURIComponent(selected.join('-'))

      setNewUrl('q', urlPrix, 'Prix')
    })
  }
}

let filtersProductsWrapper = document.querySelector('#search_filters')
if (filtersProductsWrapper) {
  makeSliderPrix()

  // Met à jour l'url lorsque un input standard est changé
  $('body').on('change', '.filter .filter_content .wrapselect select,' +
                         '.filter .filter_content .radio input', function (event) {
    let nextEncoded = $(this).val()
    $(this).parents('.filter').find('.active').removeClass('active')
    $(this).parent('label').addClass('active')

    setNewUrl('q', nextEncoded, '')
  })

  // met à jour l'url lors du changement d'ordre
  $('body').on('change', '#js-product-list-top .products-sort-order select', function (event) {
    let nextEncoded = $(this).val()
    setNewUrl('order', nextEncoded, '')
  })

  // Met à jour l'url avec les checkbox (selection multiple)
  $('body').on('change', '.filter .filter_content .checkbox input', function (event) {
    let theParent = $(this).parent().parent()

    let inputsSelected = theParent.find('input:checked')
    let label = theParent.data('label')
    let query = [label]

    _.each(inputsSelected, function (element) {
      query.push($(element).val())
    })
    $(this).parent().toggleClass('active')

    query = query.join('-')
    setNewUrl('q', query, label)
  })

  // afficher les résultats de la requete ajax
  window.prestashop.on('updateProductList', function (data) {
    let productsListBody = document.querySelector('#products')
    if (productsListBody) {
      productsListBody.innerHTML = data.rendered_active_filters + data.rendered_products_top + data.rendered_products + data.rendered_products_bottom
    }

    let searchFilters = $('#search_filters')
    let parent = searchFilters.parent()
    searchFilters.remove()
    parent.append(data.rendered_facets)
    makeSliderPrix()
  })
}
