import Swiper from 'swiper/dist/js/swiper'

let productpage = document.querySelector('.page-product')

let thumbSwiper
let mainSwiper // eslint-disable-line no-unused-vars
let variationsSlider

let doProductsSwipers = () => {
  thumbSwiper = new Swiper('.page-product .slider_left', {
    spaceBetween: 10,
    slidesPerView: 6,
    direction: 'vertical',
    watchSlidesVisibility: true,
    watchSlidesProgress: true
  })

  mainSwiper = new Swiper('.page-product .slider_main', {
    spaceBetween: 10,
    slidesPerView: 1,
    thumbs: {
      swiper: thumbSwiper
    }
  })
}

let selectVariationSlide = (combinationId) => {
  let sliderActif = productpage.querySelector('.page-product .combinations .variations_slider .variation_slide.selected')
  if (sliderActif) {
    sliderActif.classList.remove('selected')
  }

  let sliderToActivate = productpage.querySelector('.page-product .combinations .variations_slider .variation_slide[data-combination="' + combinationId + '"]')
  if (sliderToActivate) {
    sliderToActivate.classList.add('selected')
    variationsSlider.slideTo(sliderToActivate.dataset.indexswiper)
  }
}

if (productpage) {
  doProductsSwipers()

  // Variation Slider
  variationsSlider = new Swiper('.page-product .combinations .variations_slider', {
    freeMode: true,
    slidesPerView: 'auto',
    navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev'
    }
  })

  let variationProductId = productpage.querySelector('#main').dataset.idproductattribute
  selectVariationSlide(variationProductId)

  let inputsProductQuantity = productpage.querySelectorAll('.product-quantity #quantity_wanted')
  if (inputsProductQuantity.length > 0) {
    const quantityCheck = input => {
      if (isNaN(parseInt(input.value)) || parseInt(input.value) < parseInt(input.dataset.min)) {
        input.value = input.dataset.min
      }

      let moins = input.parentNode.querySelector('.actions .min')
      if (moins) {
        if (parseInt(input.value) > parseInt(input.dataset.min)) {
          moins.removeAttribute('disabled')
        } else {
          moins.setAttribute('disabled', 'disabled')
        }
      }
    }

    for (let inputProductQuantity of inputsProductQuantity) {
      let plusMoins = inputProductQuantity.parentNode.querySelector('.actions')
      let plus = null
      let moins = null
      if (plusMoins) {
        plus = plusMoins.querySelector('.plus')
        moins = plusMoins.querySelector('.min')

        plus.onclick = e => {
          e.preventDefault()
          inputProductQuantity.value = parseInt(inputProductQuantity.value) + 1
          quantityCheck(inputProductQuantity)
        }

        moins.onclick = e => {
          e.preventDefault()
          inputProductQuantity.value = parseInt(inputProductQuantity.value) - 1
          quantityCheck(inputProductQuantity)
        }
      }

      inputProductQuantity.onchange = e => {
        e.preventDefault()
        quantityCheck(inputProductQuantity)
      }
    }
  }
}
