{*
* 2007-2018 PrestaShop
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    PrestaShop SA <contact@prestashop.com>
* @copyright 2007-2018 PrestaShop SA
* @license   http://addons.prestashop.com/en/content/12-terms-and-conditions-of-use
* International Registered Trademark & Property of PrestaShop SA
*}
{extends file='customer/page.tpl'}

{block name='page_title'}
    {l s='GDPR - Personal data' mod='psgdpr'}
{/block}

{block name='content'}
    <div class="content">
        <div class="wrapper">
            <header>
                <h1 class="title">{l s='Mes données personnelles' mod='psgdpr'}</h1>
            </header>
            <section class="page_content">
                <div class="psgdprinfo17">
                    <h2>{l s='Accéder à mes données' mod='psgdpr'}</h2>
                    <p>{l s='À tout moment, vous pouvez de récupérer les données que vous avez fournies sur notre site. Cliquez sur "Télécharger" pour télécharger automatiquement une copie de vos données personnelles dans un fichier pdf ou csv.' mod='psgdpr'}</p>
                    <a id="exportDataToCsv" class="btn btn-primary psgdprgetdatabtn17" target="_blank"
                       href="{$psgdpr_csv_controller|escape:'htmlall':'UTF-8'}">{l s='Télécharger au format CSV' mod='psgdpr'}</a>
                    <a id="exportDataToPdf" class="btn btn-primary psgdprgetdatabtn17" target="_blank"
                       href="{$psgdpr_pdf_controller|escape:'htmlall':'UTF-8'}">{l s='Télécharger au format PDF' mod='psgdpr'}</a>
                </div>
                <div class="psgdprinfo17">
                    <h2>{l s='Modification et suppression de mes données' mod='psgdpr'}</h2>
                    <p>{l s='Vous pouvez modifier vos informations personnelles disponibles dans la rubrique "Mon Compte". Pour toute autre demande concernant la rectification ou la suppression de données, merci de nous adresse votre demande via ' mod='psgdpr'}
                        <a href="{$psgdpr_contactUrl|escape:'htmlall':'UTF-8'}">{l s='notre formulaire de contact.' mod='psgdpr'}</a>. {l s='Nous étudierons votre demande dans les plus bref délais.' mod='psgdpr'}</p>
                </div>
            </section>
        </div>
    </div>
{literal}
    <script type="text/javascript">
      var psgdpr_front_controller = "{/literal}{$psgdpr_front_controller|escape:'htmlall':'UTF-8'}{literal}"
      var psgdpr_id_customer = "{/literal}{$psgdpr_front_controller|escape:'htmlall':'UTF-8'}{literal}"
      var psgdpr_ps_version = "{/literal}{$psgdpr_ps_version|escape:'htmlall':'UTF-8'}{literal}"
    </script>
{/literal}
{/block}
