{*
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author Lineven
 * @copyright 2020 Lineven
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}

{if $lineven.rlp.is_active == true}
    {if !isset($lineven.rlp.hook.datas.is_refresh) || (isset($lineven.rlp.hook.datas.is_refresh) && !$lineven.rlp.hook.datas.is_refresh)}
        <section class="lineven-relatedproducts-block"
            data-hook-code="{$lineven.rlp.hook.datas.hook_code|escape:'htmlall':'UTF-8'}"
            data-controller="{$lineven.rlp.hook.datas.controller_name|escape:'htmlall':'UTF-8'}"
            data-id-related-product="{$lineven.rlp.hook.datas.id_related_product|intval}"
            data-template-type="{$lineven.rlp.hook.datas.template_type|escape:'htmlall':'UTF-8'}"
            data-async-mode="{$lineven.rlp.hook.datas.is_async|intval}"
            data-in-tab="{if isset($lineven.rlp.hook.datas.in_tab) && $lineven.rlp.hook.datas.in_tab}1{else}0{/if}"
            data-section-key="{if isset($lineven.rlp.hook.datas.section_key)}{$lineven.rlp.hook.datas.section_key|escape:'htmlall':'UTF-8'}{/if}"
        >
    {/if}
    {if isset($lineven.rlp.hook.datas.sections) && $lineven.rlp.hook.datas.sections}
        {assign var=section_title value={$lineven.rlp.hook.datas.title}}
        {block name="lrlp_before_sections"}{/block}
        {foreach from=$lineven.rlp.hook.datas.sections key=section_key item=section name=section}
            {if $lineven.rlp.hook.datas.is_separate_results}
                {assign var=section_title value={$section.title}}
            {/if}
            {if $section.products && count($section.products)}
                <section class="lineven-relatedproducts">
                    <div class="rlp-{$lineven.rlp.hook.datas.hook_class_name|escape:'htmlall':'UTF-8'}">
                        {block name="lrlp_header"}
                            <div class="{$lineven.rlp.hook.datas.template_class_name|escape:'htmlall':'UTF-8'}">
                        {/block}
                            {block name="lrlp_title"}{/block}
                            {block name="lrlp_content_header"}{/block}
                            {block name="lrlp_content"}
                                {foreach from=$section.products item=related_product name=related_product}
                                    {assign var=id_product_attribute value=""}
                                    {assign var=product_attribute_designation value=""}
                                    {assign var=product_attribute_reference value=""}
                                    {if $related_product->has_attributes}
                                        {assign var=id_product_attribute value=$related_product->id_product_attribute}
                                        {assign var=product_attribute_designation value=$related_product->attribute_designation}
                                        {assign var=product_attribute_reference value=$related_product->attribute_reference}
                                    {/if}
                                    {assign var=product_price value=$related_product->price}
                                    {assign var=product_price_tax_excluded value=$related_product->price_tax_excluded}
                                    {assign var=product_price_without_reduction value=$related_product->price_without_reduction}
                                    {if $lineven.rlp.hook.datas.price_display == 1}
                                        {assign var=product_price value=$related_product->price_tax_excluded}
                                        {assign var=product_price_without_reduction value=$related_product->price_without_reduction_tax_excluded}
                                    {/if}
                                    {block name="lrlp_product"}{/block}
                                {/foreach}
                            {/block}
                            {block name="lrlp_content_footer"}{/block}
                            {block name="lrlp_footer"}
                        </div>
                        {/block}
                    </div>
                </section>
            {else}
                {if isset($lineven.rlp.hook.datas.in_tab) && $lineven.rlp.hook.datas.in_tab}
                    {include file="module:relatedproducts/views/templates/hook/_partials/product-none.tpl"}
                {/if}
            {/if}
        {/foreach}
        {block name="lrlp_after_sections"}{/block}
    {/if}
    {if !isset($lineven.rlp.hook.datas.is_refresh) || (isset($lineven.rlp.hook.datas.is_refresh) && !$lineven.rlp.hook.datas.is_refresh)}
        </section>
    {/if}
{/if}