{*
 * RelatedProducts Merchandizing (Version 3.0.2)
 *
 * @author Lineven
 * @copyright 2020 Lineven
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * International Registered Trademark & Property of Lineven
 *}

{extends file='module:relatedproducts/views/templates/hook/_partials/layout.tpl'}

{block name="lrlp_header"}
	<div id="products" class="card thumbnails">
{/block}
{block name="lrlp_title"}
	<div class="card-block">
		<div class="h1 header-title">{$section_title|escape:'htmlall':'UTF-8'}</div>
	</div>
	<hr class="header-hr"/>
{/block}
{block name="lrlp_content_header"}
	<ul class="rlp-products">
{/block}
{block name="lrlp_product"}
    {assign var=thumbnail_image_class value='product-image'}
    {if version_compare($lineven.prestashop.version, '1.7.6', '>=')}
        {assign var=thumbnail_image_class value='product-image product-thumbnail'}
    {/if}
	<li class="product-miniature rlp-product">
        {include file="module:relatedproducts/views/templates/hook/_partials/product-image.tpl" image_class=$thumbnail_image_class new_image_box_left=3 new_image_box_top=(($lineven.rlp.hook.datas.image_height/2)-6) new_flag_top="-40"}
		<br/>
        {include file="module:relatedproducts/views/templates/hook/_partials/product-reviews.tpl" class_name="thumbnails"}
        {if ((isset($lineven.rlp.hook.datas.display_thumbnails_title) && $lineven.rlp.hook.datas.display_thumbnails_title == '1') || (isset($lineven.rlp.hook.datas.display_thumbnails_description) && $lineven.rlp.hook.datas.display_thumbnails_description == '1'))}
			<div class="container-description" {if !$lineven.rlp.hook.datas.is_mobile}style="width:{$lineven.rlp.hook.datas.image_width|escape:'htmlall':'UTF-8'}px;height:{$lineven.rlp.hook.datas.description_height|escape:'htmlall':'UTF-8'}px;"{/if}>
                {if (isset($lineven.rlp.hook.datas.display_thumbnails_title) && $lineven.rlp.hook.datas.display_thumbnails_title == '1')}
                    {include file="module:relatedproducts/views/templates/hook/_partials/product-name.tpl"}
                {/if}
                {include file="module:relatedproducts/views/templates/hook/_partials/product-attribute.tpl"}
                {if (isset($lineven.rlp.hook.datas.display_thumbnails_description) && $lineven.rlp.hook.datas.display_thumbnails_description == '1')}
                    {include file="module:relatedproducts/views/templates/hook/_partials/product-description.tpl"}
                {/if}
			</div>
        {/if}
		<div style="min-height: 60px;">
			{include file="module:relatedproducts/views/templates/hook/_partials/product-price.tpl"}
    	    {include file="module:relatedproducts/views/templates/hook/_partials/product-options.tpl"}
		</div>
        {include file="module:relatedproducts/views/templates/hook/_partials/product-button.tpl"}
	</li>
{/block}

{block name="lrlp_content_footer"}
	</ul>
	<br class="clear"/>
{/block}
{block name="lrlp_footer"}
	</div>
{/block}