<article class="product-miniature" data-id-product="{$product.id_product}"
         data-id-product-attribute="{$combination.id_combination}" itemscope itemtype="http://schema.org/Product">
    {block name='product_thumbnail'}
        <a href="{$link->getProductLink($product->id_product, null, null, null, null, null, $combination.id_combination)}"
           class="thumbnail product-thumbnail">
            {if $combination.id_image > 0}
                <img src="{$link->getImageLink($product->link_rewrite, $combination.id_image, 'brand_small')}"
                     data-rjs="{$link->getImageLink($product->link_rewrite, $combination.id_image, 'brand_small_2x')}">
            {else}
                <img src="/themes/afilor_webidea/assets/images/no-picture-sm.c135c50b.jpg">
            {/if}
        </a>
    {/block}

    {block name='product_name'}
        <div class="h2" itemprop="name"><a
                    href="{$link->getProductLink($product->id_product, null, null, null, null, null, $combination.id_combination)}">{$combination.reference}</a>
        </div>
    {/block}

    {*{block name='product_description_short'}
        <div class="product-description-short" itemprop="description">{$product.description_short nofilter}</div>
    {/block}*}

    {block name='product_list_actions'}
        <div class="product-list-actions">
            {*if $combination.quantity > 0*}
                <form class="variation_button" action="{$urls.pages.cart}" method="post"
                      style="display: block!important;">
                    <input type="hidden" name="token" value="{$static_token}">
                    <input type="hidden" name="id_product" value="{$product.id}"
                           id="product_page_product_id">
                    <input type="hidden" name="id_customization"
                           value="{$product.id_customization}"
                           id="product_customization_id">
                    <input type="hidden" name="qty"
                           value="{$combination.minimal_quantity}">

                    {foreach from=$combination.attributes key=id_group item=attribute}
                        <input type="hidden" name="group[{$id_group}]" value="{$attribute.id_attribute}">
                    {/foreach}
                    {*{foreach from=$groups key=id_attribute_group item=group}

                        {if !empty($combination.attributes_values[$id_attribute_group])}

                            {foreach from=$attributesCombinations key=k item=attributeCombination}
                                {if $attributeCombination.id_attribute_group == $id_attribute_group and in_array($attributeCombination.id_attribute, $combination.attributes)}
                                    <input type="hidden" name="group[{$id_attribute_group}]" value="{$attributeCombination.id_attribute}" class="input_group_attribute">
                                    {break}
                                {/if}
                            {/foreach}

                        {else}
                            <input type="hidden" name="group[{$id_attribute_group}]" class="input_group_attribute">
                        {/if}
                    {/foreach}*}

                    <button class="add-to-cart btn-blue"
                            data-id-product="{$product.id_product}"
                            data-id-product-attribute="{$combination.id_combination}"
                            data-link-action="add-to-cart"
                            type="submit"
                            name="add"
                            data-button-action="add-to-cart">{include file='../../../../assets/svg/cart.svg'}</button>
                </form>
            {*/if*}
            {*{hook h='displayProductListFunctionalButtons' product=$product}*}
        </div>
    {/block}

    {block name='product_quick_view'}
    {/block}

    {*{block name='product_variants'}
        {include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
    {/block}*}

    {block name='product_price_and_shipping'}
        {if $product.show_price}
            <div class="product-price-and-shipping">
                <div class="variation_cell">
                    <div class="final_price">
                        {Tools::displayPrice(Product::getPriceStatic($product.id_product, false, $combination.id_combination, 6, null, false, true))}
                        <span class="currency">{$currency.sign}</span> HT
                    </div>
                    {if $combination.specific_price}
                        <div class="reduc_price">
                            {Tools::displayPrice(Product::getPriceStatic($product.id_product, false, $combination.id_combination, 6, null, false, false))}
                            <span class="currency">{$currency.sign}</span> HT
                        </div>
                    {/if}
                </div>

                {*{if $product.has_discount}
                    {hook h='displayProductPriceBlock' product=$product type="old_price"}
                    <span class="regular-price">{$product.regular_price}</span>
                    {if $product.discount_type === 'percentage'}
                        <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
                    {elseif $product.discount_type === 'amount'}
                        <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
                    {/if}
                {/if}

                {hook h='displayProductPriceBlock' product=$product type="before_price"}

                <span itemprop="price" class="price">{$product.price}</span>

                {hook h='displayProductPriceBlock' product=$product type="unit_price"}

                {hook h='displayProductPriceBlock' product=$product type="weight"}*}

                {block name='product_availability'}
                    {if $product.show_availability}
                        {*{if $combination.quantity < 1}
                            <span class='product-availability unavailable'>Produit indisponible</span>
                        {else}*}
                            <span class='product-availability available'>{$combination.quantity} pièces en stock</span>
                        {*{/if}*}
                    {/if}
                {/block}
            </div>
        {/if}
    {/block}

    {*{block name='product_flags'}
        <ul class="product-flags">
            {foreach from=$product.flags item=flag}
                <li class="{$flag.type}">{$flag.label}</li>
            {/foreach}
        </ul>
    {/block}*}

    {*{hook h='displayProductListReviews' product=$product}*}

</article>
