{block name='product_miniature_item'}
    <article class="product-miniature category-{$product.id_category_default} {if isset($class)}{$class}{/if}" data-id-product="{$product.id_product}"
             data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
        {block name='product_thumbnail'}
            <div class="thumbnail product-thumbnail">
                {if $product.cover}
                    <img src="{$product.cover.bySize.brand_small.url}"
                         data-rjs="{$product.cover.bySize.brand_small_x2.url}" alt="{$product.cover.legend}">
                {else}
                    <img src="/themes/afilor_webidea/assets/images/no-picture-sm.c135c50b.jpg">
                {/if}
            </div>
        {/block}

        {block name='product_name'}
            <div class="h2" itemprop="name">{$product.name}</div>
            <div style="word-wrap: break-word;">{$product.reference}</div>
        {/block}

        {*{block name='product_description_short'}
            <div class="product-description-short" itemprop="description">{$product.description_short nofilter}</div>
        {/block}*}

        {block name='product_quick_view'}
        {/block}

        {block name='product_variants'}
            {include file='catalog/_partials/variant-links.tpl' variants=$product.main_variants}
        {/block}

        {block name='product_price_and_shipping'}
            {if $product.show_price}
                <div class="product-price-and-shipping">


                    <div class="variation_cell">
                        <div class="topline">À partir de</div>
                        <div class="final_price">
                            {Tools::displayPrice(Product::getPriceStatic($product.id_product, false, $product.id_product_attribute, 6, null, false, true))}
                            <span class="currency">{$currency.sign}</span> HT
                        </div>
                        {if $product.specific_prices}
                            <div class="reduc_price">
                                {Tools::displayPrice(Product::getPriceStatic($product.id_product, false, $product.id_product_attribute, 6, null, false, false))}
                                <span class="currency">{$currency.sign}</span> HT
                            </div>
                        {/if}
                    </div>

                    {*{if $product.has_discount}
                        {hook h='displayProductPriceBlock' product=$product type="old_price"}
                        <span class="regular-price">{$product.regular_price}</span>
                        {if $product.discount_type === 'percentage'}
                            <span class="discount-percentage discount-product">{$product.discount_percentage}</span>
                        {elseif $product.discount_type === 'amount'}
                            <span class="discount-amount discount-product">{$product.discount_amount_to_display}</span>
                        {/if}
                    {/if}

                    {hook h='displayProductPriceBlock' product=$product type="before_price"}

                    <span itemprop="price" class="price">{$product.price}</span>

                    {hook h='displayProductPriceBlock' product=$product type="unit_price"}

                    {hook h='displayProductPriceBlock' product=$product type="weight"}*}

                    {block name='product_availability'}
                        {if $product.show_availability}
                            {*{if $product.quantity < 1}
                                <span class='product-availability unavailable'>Produit indisponible</span>
                            {else}*}
                            <span class='product-availability available'>{$product.quantity} pièces en stock</span>
                            {*{/if}*}
                        {/if}
                    {/block}
                </div>
            {/if}
        {/block}

        {*{block name='product_flags'}
            <ul class="product-flags">
                {foreach from=$product.flags item=flag}
                    <li class="{$flag.type}">{$flag.label}</li>
                {/foreach}
            </ul>
        {/block}*}

        {block name='product_list_actions'}
            <div class="product-list-actions">
                {if $product.add_to_cart_url}
                    <form class="variation_button" action="{$urls.pages.cart}" method="post"
                          style="display: block!important;">
                        <input type="hidden" name="token" value="{$static_token}">
                        <input type="hidden" name="id_product" value="{$product.id}"
                               id="product_page_product_id">
                        <input type="hidden" name="id_customization"
                               value="{$product.id_customization}"
                               id="product_customization_id">
                        <input type="hidden" name="qty"
                               value="{$product.minimal_quantity}">
                        <button class="add-to-cart btn-blue"
                                data-id-product="{$product.id_product}"
                                data-id-product-attribute="{$product.id_product_attribute}"
                                data-link-action="add-to-cart"
                                type="submit"
                                name="add"
                                data-button-action="add-to-cart">{include file='../../../../assets/svg/cart.svg'}</button>
                    </form>
                {/if}
                {hook h='displayProductListFunctionalButtons' product=$product}
            </div>
        {/block}

        {hook h='displayProductListReviews' product=$product}

        <a href="{$product.url}" class="link-product"></a>
    </article>
{/block}
