{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{if $product.show_price}

    {if $product.has_discount}
        <div class="discount_pop">
            {if $product.discount_type == 'percentage'}
                <div class="discount_pop_percentage">{$product.discount_percentage}</div>
            {else}
                <div class="discount_pop_amount">
                    -{$product.discount_amount}<sup>{$currency.sign}</sup>
                </div>
            {/if}
        </div>
    {/if}

    {if $product.id_category_default == 18 or $product.id_category_default == 14}
        <div class="prix-degressif">
            Prix dégressif selon la quantité selectionnée.
        </div>
    {/if}

    <div class="product-prices">
        {block name='product_price'}
            <div class="product-price {if $product.has_discount}has-discount{/if}" itemprop="offers" itemscope
                 itemtype="https://schema.org/Offer">
                <link itemprop="availability" href="https://schema.org/InStock"/>
                <meta itemprop="priceCurrency" content="{$currency.iso_code}">

                <div class="price_without_taxes price_block">
                    <span>H.T.</span>
                    {if $product.has_discount}
                        <div class="regular-price">{Tools::displayPrice($product.price_without_reduction_without_tax)}
                            <sup class="currency">{$currency.sign}</sup></div>
                    {/if}
                    <div class="amount">{Tools::displayPrice($product.price_tax_exc)}<sup
                                class="currency">{$currency.sign}</sup>
                    </div>
                </div>

                <div class="price_with_taxes price_block">
                    <span>T.T.C.</span>
                    {if $product.has_discount}
                        <div class="regular-price">{Tools::displayPrice($product.regular_price_amount)}<sup
                                    class="currency">{$currency.sign}</sup></div>
                    {/if}
                    <div itemprop="price" class="amount"
                         content="{$product.price_amount}">{Tools::displayPrice($product.price_amount)}<sup
                                class="currency">{$currency.sign}</sup>
                    </div>
                </div>
                {*{if $configuration.display_taxes_label}
                    <small>{$product.labels.tax_short}</small>
                {/if}*}
                {*{hook h='displayProductPriceBlock' product=$product type="price"}

                {if $product.has_discount}
                    {if $product.discount_type === 'percentage'}
                        <span class="discount-percentage">{l s='Save %percentage%' d='Shop.Theme.Catalog' sprintf=['%percentage%' => $product.discount_percentage]}</span>
                    {else}
                        <span class="discount-amount">{l s='Save %amount%' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.discount_amount]}</span>
                    {/if}
                {/if}*}
            </div>
        {/block}

        {*{block name='product_without_taxes'}
            {if $priceDisplay == 2}
                <p class="product-without-taxes">{l s='%price% tax excl.' d='Shop.Theme.Catalog' sprintf=['%price%' => $product.price_tax_exc]}</p>
            {/if}
        {/block}*}

        {*{block name='product_pack_price'}
          {if $displayPackPrice}
            <p class="product-pack-price"><span>{l s='Instead of %price%' d='Shop.Theme.Catalog' sprintf=['%price%' => $noPackPrice]}</span></p>
          {/if}
        {/block}

        {block name='product_ecotax'}
          {if $product.ecotax.amount > 0}
            <p class="price-ecotax">{l s='Including %amount% for ecotax' d='Shop.Theme.Catalog' sprintf=['%amount%' => $product.ecotax.value]}
              {if $product.has_discount}
                {l s='(not impacted by the discount)' d='Shop.Theme.Catalog'}
              {/if}
            </p>
          {/if}
        {/block}*}

        {*{block name='product_unit_price'}
            {if $displayUnitPrice}
                <p class="product-unit-price">{l s='(%unit_price%)' d='Shop.Theme.Catalog' sprintf=['%unit_price%' => $product.unit_price_full]}</p>
            {/if}
        {/block}*}

        {*{hook h='displayProductPriceBlock' product=$product type="weight" hook_origin='product_sheet'}
        {hook h='displayProductPriceBlock' product=$product type="after_price"}*}

        {*{if $product.delivery_information}
          <span class="delivery-information">{$product.delivery_information}</span>
        {/if}*}
    </div>
{/if}
