{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{extends file='catalog/listing/product-list.tpl'}

{block name='product_list_header'}
    <h1>{$category.name}</h1>
    <div id="category-description">{$category.description nofilter}</div>
    <div class="category-cover">
        <img src="{$category.image.bySize.category_default.url}"
             data-rjs="{$category.image.bySize.category_default_x2.url}" alt="{$category.image.legend}">
    </div>
    {if $category.id == 18 or $category.id == 14}
        <div class="prix-degressif">
            Prix dégressif selon la quantité selectionnée.
        </div>
    {/if}
    {*{block name='category_subcategories'}
        <aside>
            {if $subcategories|count}
                <nav class="subcategories">
                    <ul>
                        {foreach from=$subcategories item="subcategory"}
                            <li>
                                {block name='category_miniature'}
                                    {include file='catalog/_partials/miniatures/category.tpl' category=$subcategory}
                                {/block}
                            </li>
                        {/foreach}
                    </ul>
                </nav>
            {/if}
        </aside>
    {/block}*}

{/block}
