{extends file=$layout}

{block name='content'}
    <div class="wrapper content">
        <h1 class="title">{l s='Order confirmation' d='Shop.Theme.Checkout'}</h1>
        {block name='hook_payment_return'}
            {if ! empty($HOOK_PAYMENT_RETURN)}
                <section id="content-hook_payment_return">
                    {$HOOK_PAYMENT_RETURN nofilter}
                </section>
            {/if}
        {/block}

        <section id="content-hook_order_confirmation">
            {block name='order_confirmation_header'}
                <h3>{l s='Your order is confirmed' d='Shop.Theme.Checkout'}</h3>
                <p>
                    {l s='An email has been sent to your mail address %email%.' sprintf=['%email%' => $customer.email] d='Shop.Theme.Checkout'}
                    {if $order.details.invoice_url}
                        {* [1][/1] is for a HTML tag. *}
                        {l
                        s='You can also [1]download your invoice[/1]'
                        sprintf=[
                        '[1]' => "<a href='{$order.details.invoice_url}'>",
                        '[/1]' => "</a>"
                        ]
                        d='Shop.Theme.Checkout'
                        }
                    {/if}
                </p>
            {/block}

            {block name='hook_order_confirmation'}
                {$HOOK_ORDER_CONFIRMATION nofilter}
            {/block}
        </section>

        <section id="content" class="page-content page-order-confirmation">

            {block name='order_confirmation_table'}
                {include
                file='checkout/_partials/order-confirmation-table.tpl'
                products=$order.products
                subtotals=$order.subtotals
                totals=$order.totals
                labels=$order.labels
                }
            {/block}

            {block name='order_details'}
                <div id='order-details'>
                    <h3>{l s='Order details' d='Shop.Theme.Checkout'}</h3>

                    <div class="content_order_details">
                        <div class="ref">
                            <span class="label">Référence de commande</span>
                            <span class="value">{$order.details.reference}</span>
                        </div>
                        <div class="paiment">
                            <span class="label">Méthode de paiement</span>
                            <span class="value">{$order.details.payment}</span>
                        </div>
                        {if !$order.details.is_virtual}
                            <div class="shipping">
                                <div class="label">Méthode de livraison</div>
                                <div class="value">{$order.carrier.name}</div>
                            </div>
                        {/if}
                    </div>
                </div>
            {/block}

            {block name='customer_registration_form'}
                {if $customer.is_guest}
                    <div id='registration-form'>
                        <h4>{l s='Save time on your next order, sign up now' d='Shop.Theme.Checkout'}</h4>
                        {render file='customer/_partials/customer-form.tpl' ui=$register_form}
                    </div>
                {/if}
            {/block}

            {block name='hook_order_confirmation_1'}
                {hook h='displayOrderConfirmation1'}
            {/block}
        </section>

        <section id="content-hook-order-confirmation-footer">
            {hook h='displayOrderConfirmation2'}
        </section>
    </div>
{/block}
