{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{extends file='customer/page.tpl'}

{block name="content_customer_title"}
    <h1 class="title">{l s='Mes commandes' d='Shop.Theme.Customeraccount'}</h1>
{/block}
{block name='content_customer' append}
    {if $orders}
        <table class="orders_table">
            <thead>
            <tr>
                <th>{l s='Order reference' d='Shop.Theme.Checkout'}</th>
                <th>{l s='Date' d='Shop.Theme.Checkout'}</th>
                <th>{l s='Total price' d='Shop.Theme.Checkout'}</th>
                <th>{l s='Payment' d='Shop.Theme.Checkout'}</th>
                <th>{l s='Status' d='Shop.Theme.Checkout'}</th>
                <th>{l s='Invoice' d='Shop.Theme.Checkout'}</th>
                <th>&nbsp;</th>
            </tr>
            </thead>
            <tbody>
            {foreach from=$orders item=order}
                <tr>
                    <td><a href="{$order.details.details_url}">{$order.details.reference}</a></td>
                    <td>{$order.details.order_date}</td>
                    <td>{$order.totals.total.value}€</td>
                    <td>{$order.details.payment}</td>
                    <td>
              <span
                      class="order-status-label {$order.history.current.contrast}"
                      style="background-color:{$order.history.current.color}"
              >
                {$order.history.current.ostate_name}
              </span>
                    </td>
                    <td>
                        {if $order.details.invoice_url}
                            <a href="{$order.details.invoice_url}"
                               class="order-invoice-link">{l s='PDF' d='Shop.Theme.Customeraccount'}</a>
                        {else}
                            -
                        {/if}
                    </td>
                    <td>
                        <a href="{$order.details.details_url}" data-link-action="view-order-details">
                            {l s='Details' d='Shop.Theme.Customeraccount'}
                        </a>
                        {if $order.details.reorder_url}
                            <a href="{$order.details.reorder_url}"
                               class="order-reorder-link">{l s='Reorder' d='Shop.Theme.Actions'}</a>
                        {/if}
                    </td>
                </tr>
            {/foreach}
            </tbody>
        </table>
    {/if}
{/block}
