{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{extends file='customer/page.tpl'}

{block name="content_customer_title"}
    <h1 class="title">{l s='Credit slips' d='Shop.Theme.Customeraccount'}</h1>
{/block}
{block name='content_customer' append}
    {block name='credit_slip_table'}
        {if $credit_slips}
            <p class="subtitle">{l s='Credit slips you have received after canceled orders.' d='Shop.Theme.Customeraccount'}</p>
            <table id="credit-slips">
                <thead>
                <tr>
                    <th>{l s='Credit slip' d='Shop.Theme.Customeraccount'}</th>
                    <th>{l s='Order' d='Shop.Theme.Customeraccount'}</th>
                    <th>{l s='Date issued' d='Shop.Theme.Customeraccount'}</th>
                    <th>{l s='View credit slip' d='Shop.Theme.Customeraccount'}</th>
                </tr>
                </thead>
                <tbody>
                {foreach from=$credit_slips item=slip}
                    <tr>
                        <td>{$slip.credit_slip_number}</td>
                        <td><a href="{$slip.order_url_details}"
                               data-link-action="view-order-details">{$slip.order_reference}</a></td>
                        <td>{$slip.credit_slip_date}</td>
                        <td><a href="{$slip.url}">{l s='PDF' d='Shop.Theme.Customeraccount'}</a></td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        {/if}
    {/block}
{/block}
