<!doctype html>
<html lang="{$language.locale}">
<head>
    {block name='head'}
        {include file='_partials/head.tpl'}
    {/block}

    <script type="text/javascript" src="/tarteaucitron/tarteaucitron.js"></script>
    <script type="text/javascript">
      tarteaucitron.init({
        "privacyUrl": "/content/6-politique-de-confidentialite", /* Privacy policy url */

        "hashtag": "#tarteaucitron", /* Open the panel with this hashtag */
        "cookieName": "tarteaucitron", /* Cookie name */

        "orientation": "bottom", /* Banner position (top - bottom) */
        "showAlertSmall": false, /* Show the small banner on bottom right */
        "cookieslist": true, /* Show the cookie list */

        "adblocker": false, /* Show a Warning if an adblocker is detected */
        "AcceptAllCta" : true, /* Show the accept all button when highPrivacy on */
        "highPrivacy": true, /* Disable auto consent */
        "handleBrowserDNTRequest": false, /* If Do Not Track == 1, disallow all */

        "removeCredit": true, /* Remove credit link */
        "moreInfoLink": true, /* Show more info link */
        "useExternalCss": false, /* If false, the tarteaucitron.css file will be loaded */

        //"cookieDomain": ".my-multisite-domaine.fr", /* Shared cookie for multisite */

        "readmoreLink": "/content/6-politique-de-confidentialite" /* Change the default readmore link */
      });
    </script>
    <script type="text/javascript">
      tarteaucitron.user.gtagUa = 'UA-159811756-1';
      tarteaucitron.user.gtagMore = function () { /* add here your optionnal gtag() */ };
      (tarteaucitron.job = tarteaucitron.job || []).push('gtag');
    </script>
</head>
<body id="{$page.page_name}" class="{$page.body_classes|classnames}">
{block name='hook_after_body_opening_tag'}
    {hook h='displayAfterBodyOpeningTag'}
{/block}
<header id="header">
    {block name='header'}
        {include file='_partials/header.tpl'}
    {/block}
</header>

{block name='breadcrumb'}
    {include file='_partials/breadcrumb.tpl'}
{/block}

{block name='notifications'}
    {include file='_partials/notifications.tpl'}
{/block}

{block name='content'}{/block}

<footer id="footer">
    {block name='footer'}
        {include file='_partials/footer.tpl'}
    {/block}
</footer>

{block name='javascript_bottom'}
    {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
{/block}

{block name='hook_before_body_closing_tag'}
    {hook h='displayBeforeBodyClosingTag'}
{/block}
</body>
</html>
